/*
 * Digitel NR2G board specific definitions
 * 
 * Copyright (c) 2001 R SCOP Consult. (scop@vanet.com.br)
 */

#ifndef __MACH_NR2G_H
#define __MACH_NR2G_H

#include <linux/config.h>
 
#include <asm/ppcboot.h>

#define IMAP_ADDR	((uint)0xF0000000)

/* I/O physical adresses (is this early mapped??? -- Scop)*/
#define OUT_PORT_0	0xf1000000
#define IN_PORT_0	0xf1000000
#define WRFIFO_X1	0xf1000004
#define RDFIFO_X1	0xf1000004
#define WRFIFO_X2	0xf1000008
#define RDFIFO_X2	0xf1000008
#define WR_RSVD		0xf100000C
#define RD_RSVD		0xf100000C

#ifdef CONFIG_EXTIO_16BIT
# define OUT_PORT_TYPE unsigned short
#else
# define OUT_PORT_TYPE unsigned long
#endif

/* I/O ports' bitmasks */
/* ------------------- */

#ifdef CONFIG_NR2G_PROTO_ALPHA

/* OUT_PORT_0 */
#define X1_PP0		0x80000000
#define X1_PP1		0x40000000
#define X1_PP2		0x20000000
#define X1_PP3		0x10000000
#define X2_PP0		0x08000000
#define X2_PP1		0x04000000
#define X2_PP2		0x02000000
#define X2_PP3		0x01000000

#define RST_FIFO_X2	0x00800000
#define RST_FIFO_X1	0x00400000
#define X2_ST_G		0x00200000
#define X2_ST_R		0x00100000
#define X1_ST_G		0x00080000
#define X1_ST_R		0x00040000
#define LED_BIC_G	0x00020000
#define LED_BIC_R	0x00010000

#define ETH_DSQEL	0x00008000
#define ETH_LOOP	0x00004000
#define CON2_RTS	0x00002000
#define CON2_DTR	0x00001000
#define FETH2_RST	0x00000800
#define FETH2_MDC	0x00000400
#define FETH1_RST	0x00000200
#define FETH1_MDC	0x00000100

#define CON1_DTR	0x00000080
#define WAN2_DTR	0x00000040
#define WAN1_DTR	0x00000020
#define FETH2_MDO	0x00000010
#define FETH1_MDO	0x00000008
#define RTC_RST		0x00000004
#define RTC_CLK		0x00000002
#define RTC_DATA	0x00000001

/* IN_PORT_0 */
#define X1_ID0		0x80000000
#define X1_ID1		0x40000000
#define X1_ID2		0x20000000
#define X1_ID3		0x10000000
#define X2_ID0		0x08000000
#define X2_ID1		0x04000000
#define X2_ID2		0x02000000
#define X2_ID3		0x01000000

#define EMPTYFIFO_X2	0x00800000
#define HALFFIFO_X2	0x00400000
#define FULLFIFO_X2	0x00200000
#define EMPTYFIFO_X1	0x00100000
#define HALFFIFO_X1	0x00080000
#define FULLFIFO_X1	0x00040000
#define IN_RTC_DATA	0x00020000
#define RSVI_1		0x00010000

#define WAN2_ID1	0x00008000
#define WAN2_ID0	0x00004000
#define WAN2_DSR	0x00002000
#define WAN1_ID1	0x00001000
#define WAN1_ID0	0x00000800
#define WAN1_DSR	0x00000400
#define FETH2_MDI	0x00000200
#define FETH1_MDI	0x00000100
	
#define CON2_DCD	0x00000080
#define CON2_CTS	0x00000040
#define CON2_DSR	0x00000020
#define CON1_DSR	0x00000010
#define DIPSW3		0x00000008
#define DIPSW2		0x00000004
#define DIPSW1		0x00000002
#define DIPSW0		0x00000001

/* MDIO dummy bits (MDIO is not ported to proto alpha) */
# define FETH_OMDIO	0x00000000
# define FETH_IMDIO	0x00000000
# define FETH_OMDC	0x00000000
# define FETH_IMDC	0x00000000

#else /* ~CONFIG_NR2G_PROTO_ALPHA */
# ifdef CONFIG_EXTIO_16BIT 	/* Krypton */
/* Caruso KRYPTON modified outputs */
/* Bit number definitions as required by Marshall's remark:
	"bit number definitions are required for atomic bit operations
	This operations are set_bit, clear_bit and so on. Bit number must be
	used in *little endian format*" 		*/
	
# define BITWP_E2PSD	15
# define BITWP_E2PSN	14
# define BITALARM_G	13
# define BITALARM_R	12
# define BITFETH3_RST	11
# define BITFETH2_RST	10
# define BITFETH1_RST	9
# define BITCON1_RTS	8

# define BITCON1_DTR	7
# define BITLED_BIC_G	6
# define BITLED_BIC_R	5
# define BITENAAUX	4
# define BITENAFAN	3
# define BITRTC_RST	2
# define BITRTC_CLK	1
# define BITRTC_DATA	0

/* Krypton bit masks - 16-bit I/O */

# define WP_E2PSD	0x8000
# define WP_E2PSN	0x4000
# define ALARM_G	0x2000
# define ALARM_R	0x1000
# define FETH3_RST	0x0800
# define FETH2_RST	0x0400
# define FETH1_RST	0x0200
# define CON1_RTS	0x0100

# define CON1_DTR	0x0080
# define LED_BIC_G	0x0040
# define LED_BIC_R	0x0020
# define ENAAUX		0x0010
# define ENAFAN		0x0008
# define RTC_RST	0x0004
# define RTC_CLK	0x0002
# define RTC_DATA	0x0001

/* KRYPTON modified inputs */

# define ALMTEMP	0x0400
# define CON1_DCD	0x0200
# define CON1_CTS	0x0100

# define CON1_DSR	0x0080
# define ALMAUX 	0x0040
# define ALMFAN		0x0020
# define IN_RTC_DATA	0x0010
# define DIP3		0x0008
# define DIP2		0x0004
# define DIP1		0x0002
# define DIP0		0x0001

# define DIP_MASK	0x000F
# else /* if~def ( CONFIG_EXTIO_16BIT ) */

/* Output to IO_PORT_0 */
// Marshall - bit number definitions are required for atomic bit operations
//	This operations are set_bit, clear_bit and so on. Bit number must be
//	used in *little endian format*
# define BITX1_PP0		31
# define BITX1_PP1		30
# define BITX1_PP2		29
# define BITX1_HOTON		28
# define BITX2_PP0		27
# define BITX2_PP1		26
# define BITX2_PP2		25
# define BITX2_HOTON		24

# define BITGENOUT_12		23
# define BITGENOUT_13		22
# define BITGENOUT_11		21
# define BITGENOUT_10		20
# define BITLED_EJECT2		19
# define BITLED_EJECT1		18
# define BITLED_BIC_G		17
# define BITLED_BIC_R		16

# define BITGENOUT_9		15
# define BITGENOUT_8		14
# define BITGENOUT_7		13
# define BITFETH2_FULL3		12
# define BITFETH2_RST		11
# define BITFETH1_FULL3		10
# define BITFETH1_RST		9
# define BITCON1_RTS		8

# define BITCON1_DTR		7
# define BITWAN2_DTR		6
# define BITWAN1_DTR		5
# define BITFPGAPRG		4
# define BITGENIN_EN		3
# define BITRTC_RST		2
# define BITRTC_CLK		1
# define BITRTC_DATA		0

// Marshall - Bit Masks
# define X1_PP0		0x80000000
# define X1_PP1		0x40000000
# define X1_PP2		0x20000000
# define X1_HOTON	0x10000000
# define X2_PP0		0x08000000
# define X2_PP1		0x04000000
# define X2_PP2		0x02000000
# define X2_HOTON	0x01000000

# define GENOUT_12	0x00800000
# define GENOUT_13	0x00400000
# define GENOUT_11	0x00200000
# define GENOUT_10	0x00100000
# define LED_EJECT2	0x00080000
# define LED_EJECT1	0x00040000
# define LED_BIC_G	0x00020000
# define LED_BIC_R	0x00010000

# define GENOUT_9	0x00008000
# define GENOUT_8	0x00004000
# define GENOUT_7	0x00002000
# define FETH2_FULL3	0x00001000
# define FETH2_RST	0x00000800
# define FETH1_FULL3	0x00000400
# define FETH1_RST	0x00000200
# define CON1_RTS	0x00000100

# define CON1_DTR	0x00000080
# define WAN2_DTR	0x00000040
# define WAN1_DTR	0x00000020
# define FPGAPRG	0x00000010
# define GENIN_EN	0x00000008
# define RTC_RST	0x00000004
# define RTC_CLK	0x00000002
# define RTC_DATA	0x00000001

/* Input from IO_PORT_0 */
# define X1_ID0		0x80000000
# define X1_ID1		0x40000000
# define X1_ID2		0x20000000
# define X1_ID3		0x10000000
# define X2_ID0		0x08000000
# define X2_ID1		0x04000000
# define X2_ID2		0x02000000
# define X2_ID3		0x01000000

# define GENIN_8	0x00800000
# define GENIN_9	0x00400000
# define GENIN_10	0x00200000
# define GENIN_11	0x00100000
# define GENIN_12	0x00080000
# define GENIN_13	0x00040000
# define FPGADONE	0x00020000
# define IN_RTC_DATA	0x00010000

# define WAN2_ID1	0x00008000
# define WAN2_ID0	0x00004000
# define WAN2_DSR	0x00002000
# define WAN1_ID1	0x00001000
# define WAN1_ID0	0x00000800
# define WAN1_DSR	0x00000400
# define CON1_DCD	0x00000200
# define CON1_CTS	0x00000100
	
# define CON1_DSR	0x00000080
# define FPGA_PWRGD	0x00000040
# define EJECT2		0x00000020
# define EJECT1		0x00000010
# define DIP3		0x00000008
# define DIP2		0x00000004
# define DIP1		0x00000002
# define DIP0		0x00000001

# define DIP_MASK	0x0000000F
# endif		/* ifdef ( CONFIG_EXTIO_16BIT ) */

/* PORT B bits */
# define FETH_OMDIO	0x08000000
# define FETH_IMDIO	0x04000000
# define FETH_OMDC	0x02000000
# define FETH_IMDC	0x01000000

#endif /* CONFIG_NR2G_PROTO_ALPHA */

/* macro for setting regs through a shadow -
 * r = i/o port address (like OUT_PORT_0)
 * s = shadow (mirror) variable (like m_outp)
 * b = bit mask
 * v = value (0 or 1)
 * (This was originally borrowed from include/asm-cris/io.h -- Scop)
 */
  
#if 0
# define IO_SET(r,s,b,v) *r = s = (OUT_PORT_TYPE) (s & ~(1 << (b))) | ((v) << (b))
#else
# define IO_SET(r,s,b,v) *r = s = (OUT_PORT_TYPE) ((v) ? (s | (b)) : (s & ~(b)))
# define IO_REV(r,s,b) *r = s ^= (OUT_PORT_TYPE) (b)
#endif

/*
 * Port pins used for bit-banged I/O communications (if applicable).
 */
/* Caruso: The MII code bellow applies to the alpha version NR2G only (if so).
---------------------------------------------------------------
#define MDIO_READ	((*outp &  0x00000100) != 0)

#define MDIO(bit)	if(bit) *outp = (m_outp.n |= (ulong)  0x00000008); \
			else    *outp = (m_outp.n &= (ulong) ~0x00000008)

#define MDC(bit)	if(bit) *iop = (m_outp.n |= (ulong)  0x00000100); \
			else    *outp = (m_outp.n &= (ulong) ~0x00000100)

#define MIIDELAY udelay(2)
---------------------------------------------------------------*/

#define SET_LED_BIC_G(x) IO_SET(outp, m_outp.n, LED_BIC_G, x)
#define SET_LED_BIC_R(x) IO_SET(outp, m_outp.n, LED_BIC_R, x)
#define REV_LED_BIC_R IO_REV(outp, m_outp.n, LED_BIC_R)
#define REV_LED_BIC_G IO_REV(outp, m_outp.n, LED_BIC_G)

/* Caruso - controle dos LED de alarme para o Krypton */
#define SET_ALARM_G(x) IO_SET(outp, m_outp.n, ALARM_G, x)
#define SET_ALARM_R(x) IO_SET(outp, m_outp.n, ALARM_R, x)
#define REV_ALARM_R IO_REV(outp, m_outp.n, ALARM_R)
#define REV_ALARM_G IO_REV(outp, m_outp.n, ALARM_G)


// Marshall - Macros and definitions to identify the module
#define MODULE_ID(i,m)	(m < 1 ? ((i>>28) & 0xF):((i>>24) & 0xF))

#define MODULE_WAN1		0x0
#define MODULE_VOIP4FXS	        0x8
#define MODULE_VOIP4FXO	        0x9
#define MODULE_WAN2		0x3
#define MODULE_SWITCH	        0x4
#define MODULE_G703		0x5
#define NO_MODULE		0xF


/* I/O ports' structures (bit-fields... is this portable??? -- Scop) */

/* Caruso - Krypton has 16bit io width. */
#ifdef CONFIG_EXTIO_16BIT

struct outp_s {	/* output port format */
	unsigned short wp_e2psd : 1;
	unsigned short wp_e2psn : 1;
	unsigned short alarm_g : 1;
	unsigned short alarm_r : 1;
	unsigned short feth3_rst : 1;
	unsigned short feth2_rst : 1;
	unsigned short feth1_rst : 1;
	unsigned short con1_rts : 1;
	
	unsigned short con1_dtr : 1;
	unsigned short led_bic_g : 1;
	unsigned short led_bic_r : 1;
	unsigned short ena_aux : 1;
	unsigned short ena_fan : 1;
	unsigned short rtc_rst : 1;
	unsigned short rtc_clk : 1;
	unsigned short rtc_data : 1;
};
union outp_u {
	struct outp_s f;
	unsigned short n;
};


struct inp_s {	/* formato da porta de entrada */
/* KRYPTON modified inputs */
	unsigned int dummy : 5;
	unsigned int alm_temp : 1;
	unsigned int con1_dcd : 1;
	unsigned int con1_cts : 1;

	unsigned int con1_dsr : 1;
	unsigned int alm_aux : 1;
	unsigned int alm_fan : 1;
	unsigned int rtc_data : 1;		/*  */
	unsigned int dipsw : 4;
};
union inp_u {
	struct inp_s f;
	unsigned short n;
};

#else /* ifdef CONFIG_EXTIO_16BIT */

struct outp_s {	/* output port format */
	unsigned int x1_pp0 : 1;	/* D0 8000.0000 */
	unsigned int x1_pp1 : 1;	/* D1 4000.0000 */
	unsigned int x1_pp2 : 1;    /* etc... */
	unsigned int x1_pp3 : 1;
	unsigned int x2_pp0 : 1;
	unsigned int x2_pp1 : 1;
	unsigned int x2_pp2 : 1;
	unsigned int x2_pp3 : 1;

	unsigned int rstfifo_x2 : 1;
	unsigned int rstfifo_x1 : 1;
	unsigned int x2_st_g : 1;
	unsigned int x2_st_r : 1;
	unsigned int x1_st_g : 1;
	unsigned int x1_st_r : 1;
	unsigned int led_bic_g : 1;
	unsigned int led_bic_r : 1;

	unsigned int eth_dsqel : 1;
	unsigned int eth_loop : 1;
	unsigned int con2_rts : 1;
	unsigned int con2_dtr : 1;
	unsigned int feth2_rst : 1;
	unsigned int feth2_mdc : 1;
	unsigned int feth1_rst : 1;
	unsigned int feth1_mdc : 1;

	unsigned int con1_dtr : 1;
	unsigned int wan2_dtr : 1;
	unsigned int wan1_dtr : 1;
	unsigned int feth2_mdio : 1;
	unsigned int feth1_mdio : 1;
	unsigned int rtc_rst : 1;
	unsigned int rtc_clk : 1;
	unsigned int rtc_data : 1;
};
union outp_u {
	struct outp_s f;
	unsigned long n;
};


struct inp_s {	/* formato da porta de entrada */
	unsigned int x1_ID0 : 1;		/* D0 8000.0000 */
	unsigned int x1_ID1 : 1;		/* D1 4000.0000 */
	unsigned int x1_ID2 : 1;		/* D2 2000.0000 */
	unsigned int x1_ID3 : 1;		/* D3 1000.0000 */
	unsigned int x2_ID0 : 1;		/* D4 0800.0000 */
	unsigned int x2_m_outpID1 : 1;		/* D5 0400.0000 */
	unsigned int x2_ID2 : 1;		/* D6 0200.0000 */
	unsigned int x2_ID3 : 1;		/* D7 0100.0000 */

	unsigned int emptyfifo_X2 : 1;		/*  */
	unsigned int halffifo_X2 : 1;		/*  */
	unsigned int fullfifo_X2 : 1;		/*  */
	unsigned int emptyfifo_X1 : 1;		/*  */
	unsigned int halffifo_X1 : 1;		/*  */
	unsigned int fullfifo_X1 : 1;		/*  */
#ifdef CONFIG_NR2G_PROTO_ALPHA	
	unsigned int rtc_data : 1;		/*  */
	unsigned int rsvi_1 : 1;		/*  */
#else
	unsigned int fpgadone : 1;		/*  */
	unsigned int rtc_data : 1;		/*  */
#endif	
	unsigned int wan2_id1 : 2;
	unsigned int wan2_id0 : 2;
	unsigned int wan2_dsr : 1;
	unsigned int wan1_id1 : 2;
	unsigned int wan1_id0 : 2;
	unsigned int wan1_dsr : 1;
	unsigned int feth2_mdio : 1;
	unsigned int feth1_mdio : 1;
	
	unsigned int con2_dcd : 1;
	unsigned int con2_cts : 1;
	unsigned int con2_dsr : 1;
	unsigned int con1_dsr : 1;
	unsigned int dipsw : 4;
};
union inp_u {
	struct inp_s f;
	unsigned long n;
};

#endif /* CONFIG_EXTIO_16BIT */

/* globals */

/* extern volatile union outp_u *outp;	I/O ports
extern volatile union inp_u *inp; */
extern union outp_u m_outp;			 /* output port mirror */

#endif	/* __MACH_NR2G_H */
