/************************************************************************
	commproc_add.h
	additions to commproc.h
	Tobias Otto-Adamczak <toa@epost.de>, November 2000
        Version modified by Adam Kaczynski.
 ************************************************************************/

/* SCC parameter RAM for HDLC mode
*/
typedef struct scc_hdlc {
	sccp_t	scc_gen;	/* generic SCC parameters */
	uint	scc_res1;	/* reserved */
	uint	scc_cmask;	/* CRC mask */
	uint	scc_cpres;	/* CRC preset */
	ushort	scc_disfc;	/* discarded frame counter */
	ushort	scc_crcec;	/* CRC error counter */
	ushort	scc_abtsc;	/* abort sequence counter */
	ushort	scc_nmarc;	/* nonmatching address receive counter */
	ushort	scc_retrc;	/* frame retransmission counter */
	ushort	scc_mflr;	/* Max frame length register */
	ushort	scc_maxcnt;	/* internal */
	ushort	scc_rfthr;	/* received frames threshold */
	ushort	scc_rfcnt;	/* internal */
	ushort	scc_hmask;	/* HDLC address mask register */
	ushort	scc_haddr1;	/* HDLC address register 1 */
	ushort	scc_haddr2;	/* HDLC address register 2 */
	ushort	scc_haddr3;	/* HDLC address register 3 */
	ushort	scc_haddr4;	/* HDLC address register 4 */
	ushort	scc_tmp;	/* internal */
	ushort	scc_tmp_mb;	/* internal */
} scc_hdlc_t;

/* additional BD SC register flags for SCC in HDLC mode
*/
#define BD_SC_RD	((ushort)0x8000) /* Ready */
#define BD_SC_INT	((ushort)0x1000) /* Interrupt */
#define BD_SC_WRP	((ushort)0x2000) /* Wrap */
#define BD_SC_LST	((ushort)0x0800) /* Last buffer in frame */
#define BD_SC_TC	((ushort)0x0400) /* Transmit CRC */
#define BD_SC_LG	((ushort)0x0020) /* Rx frame length violation */
#define BD_SC_NO	((ushort)0x0010) /* Rx non-octet aligned frame */
#define BD_SC_AB	((ushort)0x0008) /* Rx abort sequence */
#define BD_SC_CR	((ushort)0x0004) /* Rx CRC error */
#define BD_SC_OV        ((ushort)0x0002) /* Rx overrun error / Tx Underrun */
#define BD_SC_ALL_ERR   ((ushort)0x00bf) /* All possible Rx errors */
/* SCC event/mask register flags in HDLC mode
*/
#define SCCE_HDLC_GLR	((ushort)0x1000) /* Rx clock glitch detect */
#define SCCE_HDLC_GLT	((ushort)0x0800) /* Tx clock glitch detect */
#define SCCE_HDLC_DCC	((ushort)0x0400) /* DPLL carrier sense change */
#define SCCE_HDLC_FLG	((ushort)0x0200) /* HDLC flag status change */
#define SCCE_HDLC_IDL	((ushort)0x0100) /* idle sequence status change */
#define SCCE_HDLC_GRA	((ushort)0x0080) /* graceful stop complete */
#define SCCE_HDLC_TXE	((ushort)0x0010) /* Tx error */
#define SCCE_HDLC_RXF	((ushort)0x0008) /* RFTHR frames received */
#define SCCE_HDLC_BSY	((ushort)0x0004) /* busy (lack of Rx buffers) */
#define SCCE_HDLC_TXB	((ushort)0x0002) /* Tx buffer sent */
#define SCCE_HDLC_RXB	((ushort)0x0001) /* Rx buffer received */

/* SCC protocol-specific mode register flags in HDLC mode
*/
#define PSMR_HDLC_NOF_MSK ((ushort)0xF000) /* number of flags mask */
#define PSMR_HDLC_CRC16	((ushort)0x0000) /* CRC16 */
#define PSMR_HDLC_CRC32	((ushort)0x0800) /* CRC32 */
#define PSMR_HDLC_RTE	((ushort)0x0200) /* retransmit enable */
#define PSMR_HDLC_FSE	((ushort)0x0080) /* flag sharing enable */
#define PSMR_HDLC_DRT	((ushort)0x0040) /* disable Rx while transmitting */
#define PSMR_HDLC_BUS	((ushort)0x0020) /* HDLC bus mode */
#define PSMR_HDLC_BRM	((ushort)0x0010) /* HDLC bus RTS mode */
#define PSMR_HDLC_MFF	((ushort)0x0008) /* multiple frames per Tx FIFO */

/* SI RAM entry fields
*/
#define SI_RAM_LOOP	((uint)0x80000000) /* Loopback on this time slot */
#define SI_RAM_SWTR	((uint)0x40000000) /* Switch Tx/Rx */
#define SI_RAM_SSEL4	((uint)0x20000000) /* Strobe select 4 */
#define SI_RAM_SSEL3	((uint)0x10000000) /* Strobe select 3 */
#define SI_RAM_SSEL2	((uint)0x08000000) /* Strobe select 2 */
#define SI_RAM_SSEL1	((uint)0x04000000) /* Strobe select 1 */
#define SI_RAM_ROUT_MSK	((uint)0x01c00000) /* time slot routing mask */
#define SI_RAM_UNUSED	((uint)0x00000000) /* time slot unused */
#define SI_RAM_SCC1	((uint)0x00400000) /* time slot routed to SCC1 */
#define SI_RAM_SCC2	((uint)0x00800000) /* time slot routed to SCC2 */
#define SI_RAM_SCC3	((uint)0x00c00000) /* time slot routed to SCC3 */
#define SI_RAM_SCC4	((uint)0x01000000) /* time slot routed to SCC4 */
#define SI_RAM_SMC1	((uint)0x01400000) /* time slot routed to SMC1 */
#define SI_RAM_SMC2	((uint)0x01800000) /* time slot routed to SMC2 */
#define SI_RAM_UNUSED1	((uint)0x01c00000) /* time slot unused */
#define SI_RAM_CNT_MSK	((uint)0x003c0000) /* bit/byte count mask */
#define SI_RAM_BYTE	((uint)0x00020000) /* count resolution is byte */
#define SI_RAM_LAST	((uint)0x00010000) /* last entry */

/* SIGMR (SI global mode register)
*/
#define SIGMR_ENB	((u_char)0x08) /* enable TDMb */
#define SIGMR_ENA	((u_char)0x04) /* enable TDMa */
#define SIGMR_RDMSK	((u_char)0x03) /* RAM division mode mask */
#define SIGMR_STATIC	((u_char)0x00) /* RAM division mode: static TDM, 64 entries*/
#define SIGMR_DYNAMIC	((u_char)0x01) /* RAM division mode: dynamic TDM, 32 entries */
#define SIGMR_STATIC_32	((u_char)0x02) /* RAM division mode: static 2*TDM, 2*32 entries */
#define SIGMR_DYN_16	((u_char)0x03) /* RAM division mode: dynamic 2*TDM, 2*16 entries  */

/* SIMODE register
*/
#define SIMODE_SMC2_TDM	((uint)0x80000000) /* SMC2 connects to TSA */
#define SIMODE_B_NORMAL	((uint)0x00000000) /* TDM b: no loop, no echo */
#define SIMODE_B_ECHO	((uint)0x04000000) /* TDM b: echo mode */
#define SIMODE_B_LOOP	((uint)0x08000000) /* TDM b: loopback mode, out ports active */
#define SIMODE_B_LOOPC	((uint)0x0c000000) /* TDM b: loopback mode */
#define SIMODE_B_RFSD_0	((uint)0x00000000) /* TDM b: Rx frame sync delay 0 bit */
#define SIMODE_B_RFSD_1	((uint)0x01000000) /* TDM b: Rx frame sync delay 1 bit */
#define SIMODE_B_RFSD_2	((uint)0x02000000) /* TDM b: Rx frame sync delay 2 bit */
#define SIMODE_B_RFSD_3	((uint)0x03000000) /* TDM b: Rx frame sync delay 3 bit */
#define SIMODE_B_DSC	((uint)0x00800000) /* TDM b: double speed clk */
#define SIMODE_B_CRT	((uint)0x00400000) /* TDM b: common clk/sync pins for Rx/Tx */
#define SIMODE_B_STZ	((uint)0x00200000) /* TDM b: set TxD to zero */
#define SIMODE_B_CE 	((uint)0x00100000) /* TDM b: clock edge */
#define SIMODE_B_FE 	((uint)0x00080000) /* TDM b: rising frame sync edge */
#define SIMODE_B_GM 	((uint)0x00040000) /* TDM b: IDL grant mode */
#define SIMODE_B_TFSD_0	((uint)0x00000000) /* TDM b: Tx frame sync delay 0 bit */
#define SIMODE_B_TFSD_1	((uint)0x00010000) /* TDM b: Tx frame sync delay 1 bit */
#define SIMODE_B_TFSD_2	((uint)0x00020000) /* TDM b: Tx frame sync delay 2 bit */
#define SIMODE_B_TFSD_3	((uint)0x00030000) /* TDM b: Tx frame sync delay 3 bit */

#define SIMODE_SMC1_TDM	((uint)0x00008000) /* SMC1 connects to TSA */
#define SIMODE_A_NORMAL	((uint)0x00000000) /* TDM a: no loop, no echo */
#define SIMODE_A_ECHO	((uint)0x00000400) /* TDM a: echo mode */
#define SIMODE_A_LOOP	((uint)0x00000800) /* TDM a: loopback mode, out ports active */
#define SIMODE_A_LOOPC	((uint)0x00000c00) /* TDM a: loopback mode */
#define SIMODE_A_RFSD_0	((uint)0x00000000) /* TDM a: Rx frame sync delay 0 bit */
#define SIMODE_A_RFSD_1	((uint)0x00000100) /* TDM a: Rx frame sync delay 1 bit */
#define SIMODE_A_RFSD_2	((uint)0x00000200) /* TDM a: Rx frame sync delay 2 bit */
#define SIMODE_A_RFSD_3	((uint)0x00000300) /* TDM a: Rx frame sync delay 3 bit */
#define SIMODE_A_DSC	((uint)0x00000080) /* TDM a: double speed clk */
#define SIMODE_A_CRT	((uint)0x00000040) /* TDM a: common clk/sync pins for Rx/Tx */
#define SIMODE_A_STZ	((uint)0x00000020) /* TDM a: set TxD to zero */
#define SIMODE_A_CE 	((uint)0x00000010) /* TDM a: clock edge */
#define SIMODE_A_FE 	((uint)0x00000008) /* TDM a: rising frame sync edge */
#define SIMODE_A_GM 	((uint)0x00000004) /* TDM a: IDL grant mode */
#define SIMODE_A_TFSD_0	((uint)0x00000000) /* TDM a: Tx frame sync delay 0 bit */
#define SIMODE_A_TFSD_1	((uint)0x00000001) /* TDM a: Tx frame sync delay 1 bit */
#define SIMODE_A_TFSD_2	((uint)0x00000002) /* TDM a: Tx frame sync delay 2 bit */
#define SIMODE_A_TFSD_3	((uint)0x00000003) /* TDM a: Tx frame sync delay 3 bit */

/* SICR (SI clock route register): TSA bits, grant support
*/
#define SICR_SCC4_GR	((uint)0x80000000) /* SCC4 grant support */
#define SICR_SCC4_TDM	((uint)0x40000000) /* SCC4 connects to TSA */
#define SICR_SCC3_GR	((uint)0x00800000) /* SCC3 grant support */
#define SICR_SCC3_TDM	((uint)0x00400000) /* SCC3 connects to TSA */
#define SICR_SCC2_GR	((uint)0x00008000) /* SCC2 grant support */
#define SICR_SCC2_TDM	((uint)0x00004000) /* SCC2 connects to TSA */
#define SICR_SCC1_GR	((uint)0x00000080) /* SCC1 grant support */
#define SICR_SCC1_TDM	((uint)0x00000040) /* SCC1 connects to TSA */

/* SICMR (SI Command Register)
*/
#define SICMR_CSRRA	((u_char)0x80) /* change SI RAM routing for TDMa Rx */
#define SICMR_CSRTA	((u_char)0x40) /* change SI RAM routing for TDMa Tx */
#define SICMR_CSRRB	((u_char)0x20) /* change SI RAM routing for TDMb Rx */
#define SICMR_CSRTB	((u_char)0x10) /* change SI RAM routing for TDMb Tx */

/* SISTR (SI status register)
*/
#define SISTR_CRORA	((u_char)0x80) /* TDMa Rx SI RAM address area */
#define SISTR_CROTA	((u_char)0x40) /* TDMa Tx SI RAM address area */
#define SISTR_CRORB	((u_char)0x20) /* TDMb Rx SI RAM address area */
#define SISTR_CROTB	((u_char)0x10) /* TDMb Tx SI RAM address area */
