
/* SCC HDLC Communication Processor Module extensions
 * Copyright 2002 R SCOP Consult.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This file was based on QS850 cpm.h file from SNMC. I just checked it for
 * 826x cpu, and changed some names.
 *
 * ORIGINAL COPYRIGHT MESSAGES:
 * -------------------------------------------------------------------------
 * Copyright 2000 SNMC
 * Simple Network Magic Corporation
 * -------------------------------------------------------------------------
 *
 * This file adds CPM data structure extensions for
 * HDLC in SCC.
 */

#ifndef __CPM_HDLC_H__
#define __CPM_HDLC_H__

#ifdef __KERNEL__

#ifdef CONFIG_8xx
# include <asm/8xx_immap.h>
# include <asm/commproc.h>
#else /* 8260 */
# include <asm/immap_8260.h>
# include <asm/cpm_8260.h>
#endif

#define SCCM_RXF    ((unsigned char)0x08)

/* CPM HDLC Parameter Ram defintions for an SCC Controller */

typedef struct scc_hdlc {
	sccp_t	genscc;
	uint	res1;				/* Reserved */
	uint	c_mask;			/* CRC mask */
	uint	c_pres;			/* CRC preset */
	ushort	disfc;		/* Discarded Frame Counter */
	ushort	crcec;		/* CRC Error Counter */
	ushort	abtsc;		/* Abort Sequence Counter */
	ushort	nmarc;		/* NonMatching Address Rcvd Counter */
	ushort	retrc;		/* Retransmitted Frame Counter */
	ushort	mflr;			/* Max frame length */
	ushort	max_cnt;		/* Maximum length counter (reserved) */
	ushort	rfthr;		/* Receved Frame Threshold */
	ushort	rfcnt;		/* Received Frames Count */
	ushort	hmask;		/* Address Mask */
	ushort	haddr1;		/* Address #1 */
	ushort	haddr2;		/* Address #2 */
	ushort	haddr3;		/* Address #3 */
	ushort	haddr4;		/* Address #4 */
	ushort	tmp1;			/* Temp storage (reserved) */
	ushort	tmp_mb;		/* Temp storage (reserved) */

} scc_hdlc_t;


/* Buffer descriptor control/status used by HDLC transmit */

#define BD_HDLC_TX_READY	((ushort)0x8000)
#define BD_HDLC_TX_WRAP		((ushort)0x2000)
#define BD_HDLC_TX_INTRPT	((ushort)0x1000)
#define BD_HDLC_TX_LAST		((ushort)0x0800)
#define BD_HDLC_TX_CRC		((ushort)0x0400)
#define BD_HDLC_TX_CONTM	((ushort)0x0200)
#define BD_HDLC_TX_UN		((ushort)0x0002)
#define BD_HDLC_TX_CL		((ushort)0x0001)

#define BD_HDLC_TX_STATS	(BD_HDLC_TX_CONTM|BD_HDLC_TX_UN|BD_HDLC_TX_CL)

/* Buffer descriptor control/status used by HDLC receive. */

#define BD_HDLC_RX_EMPTY	((ushort)0x8000)
#define BD_HDLC_RX_WRAP		((ushort)0x2000)
#define BD_HDLC_RX_INTRPT	((ushort)0x1000)
#define BD_HDLC_RX_LAST		((ushort)0x0800)
#define BD_HDLC_RX_FIRST	((ushort)0x0400)
#define BD_HDLC_RX_CONTM	((ushort)0x0200)
#define BD_HDLC_RX_DE		((ushort)0x0080)
#define BD_HDLC_RX_LG		((ushort)0x0020)
#define BD_HDLC_RX_NO		((ushort)0x0010)
#define BD_HDLC_RX_AB		((ushort)0x0008)
#define BD_HDLC_RX_CRC		((ushort)0x0004)
#define BD_HDLC_RX_OV		((ushort)0x0002)
#define BD_HDLC_RX_CD		((ushort)0x0001)

#define BD_HDLC_RX_STATS	(BD_HDLC_RX_CONTM|BD_HDLC_RX_DE|BD_HDLC_RX_LG|BD_HDLC_RX_NO|BD_HDLC_RX_AB|BD_HDLC_RX_CRC|BD_HDLC_RX_OV|BD_HDLC_RX_CD)

/* SCC Event/Mask registers as used by HDLC.
*/
#define SCCE_HDLC_GLR	((ushort)0x1000)	/* Glitch on Rx */
#define SCCE_HDLC_GLT	((ushort)0x0800)	/* Glitch on Tx */
#define SCCE_HDLC_DCC	((ushort)0x0400)	/* DPLL carrier sense change*/
#define SCCE_HDLC_FLG	((ushort)0x0200)	/* Flag status */
#define SCCE_HDLC_IDL	((ushort)0x0100)	/* Idle sequence status change */
#define SCCE_HDLC_GRA	((ushort)0x0080)	/* Graceful stop complete */
#define SCCE_HDLC_TXE	((ushort)0x0010)	/* Transmit Error */
#define SCCE_HDLC_RXF	((ushort)0x0008)	/* Full frame received */
#define SCCE_HDLC_BSY	((ushort)0x0004)	/* All incoming buffers full */
#define SCCE_HDLC_TXB	((ushort)0x0002)	/* A buffer was transmitted */
#define SCCE_HDLC_RXB	((ushort)0x0001)	/* A buffer was received */

/* SCC Mode Register (PSMR) as used by HDLC.
*/
#define SCH_PSMR_NOF1 ((ushort)0x1000)	/* Number of flags = 1 */
#define SCH_PSMR_CRC16	((ushort)0x0000)	/* CRC16 selection */
#define SCH_PSMR_CRC32  ((ushort)0x0800)  /* CRC32 selection */
#define SCH_PSMR_RTE	((ushort)0x0200)	/* Retransmit enable */
#define SCH_PSMR_FSE	((ushort)0x0080)	/* Flag sharing enable */
#define SCH_PSMR_DRT	((ushort)0x0040)	/* Disable receiver while tx */
#define SCH_PSMR_BUS	((ushort)0x0020)	/* HDLC Bus mode */
#define SCH_PSMR_BRM	((ushort)0x0010)	/* Special HDLC bus RTS mode */
#define SCH_PSMR_MFF	((ushort)0x0008)	/* Multiple frames in Tx FIFO */


#endif /* __KERNEL__ */

#endif /* __CPM_HDLC_H__ */



