
/* SCC HDLC device driver definitions.
 * Copyright 2002 R SCOP Consult.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This file is almost identical to QS850 hdlcppp.h file from SNMC. I just
 * changed some names and comments.
 *
 * ORIGINAL COPYRIGHT MESSAGES:
 * -------------------------------------------------------------------------
 * Copyright 2000 SNMC
 * Simple Network Magic Corporation
 * -------------------------------------------------------------------------
 *
 * This file defines the user interface to the SCC HDLC device driver.
 */

#ifndef __SCCHDLC_H__
#define __SCCHDLC_H__

#include <linux/sockios.h>


/* Commands used in ioctl() for SCC HDLC driver */
enum {
	SCCHDLCIOCNOLOOPECHO = (SIOCDEVPRIVATE+32), /* Normal operation */
	SCCHDLCIOCLOOP,				/* Loopback Mode */
	SCCHDLCIOCECHO,				/* Echo Mode */
	SCCHDLCIOCLOOPECHO,			/* Loopback+Echo Mode */
	SCCHDLCIOCTXCLKFALL,		/* Tx Data on Falling edge */
	SCCHDLCIOCTXCLKRISE			/* Tx Data on Rising edge */
};

#endif /* __SCCHDLC_H__ */

