/*
 * Digitel TRITON board specific definitions
 * 
 * Copyright (c) 2002 R SCOP Consult. (scop@vanet.com.br)
 */

#ifndef __MACH_TRITON_H
#define __MACH_TRITON_H

#include <linux/config.h>
 
#include <asm/ppcboot.h>

#define	TRITON_IMMR_BASE	0xFF000000	/* phys. addr of IMMR */
#define	TRITON_IMAP_SIZE	(64 * 1024)	/* size of mapped area */

#define	IMAP_ADDR	TRITON_IMMR_BASE	/* physical base address of IMMR area */
#define IMAP_SIZE	TRITON_IMAP_SIZE	/* mapped size of IMMR area */

/* Interrupt level assignments.
*/
/* SCOP: VERIFY! */
#define FEC_INTERRUPT	SIU_LEVEL1	/* FEC interrupt */
#define PHY_INTERRUPT   SIU_IRQ6    /* PHY link change interrupt */

/* We don't use the 8259.
*/
#define NR_8259_INTS	0

/*
* enderecos das portas de I/O externas
*/

/* porta de escrita */
#define ADDR_OUTP0	0xF0000000

/* portas de leitura */
#define ADDR_INP0	0xF0000000
#define ADDR_INP1	0xF0000004

/* macro for setting regs through a shadow -
 * r = i/o port address (like OUT_PORT_0)
 * s = shadow (mirror) variable (like m_outp)
 * b = bit mask
 * v = value (0 or 1)
 * (This was originally borrowed from include/asm-cris/io.h -- Scop)
 */
#if 0
# define IO_SET(r,s,b,v) *r = s = (s & ~(1 << (b))) | ((v) << (b))
#else
# define IO_SET(r,s,b,v) *r = s = (v) ? (s | (b)) : (s & ~(b))
# define IO_REV(r,s,b) *r = s ^= (b)
#endif

#define LED_BIC_G	0x00000002
#define LED_BIC_R	0x00000001

#define SET_LED_BIC_G(x) IO_SET(outp, m_outp, LED_BIC_G, x)
#define SET_LED_BIC_R(x) IO_SET(outp, m_outp, LED_BIC_R, x)
#define REV_LED_BIC_R IO_REV(outp, m_outp, LED_BIC_R)
#define REV_LED_BIC_G IO_REV(outp, m_outp, LED_BIC_G)


#endif	/* __MACH_TRITON_H */
