/*
 * lsym.c
 * very simple symbol table code to support labeling the a/b/c-memory
 *
 * Copyright (C) 2004 Brad Parker <brad@heeltoe.com>
 * $Id: lsym.c,v 1.2 2004/05/28 18:26:03 brad Exp $
 */

#include <stdio.h>
#include <unistd.h>
#include <string.h>

char *sym_file;

struct sym_s {
	struct sym_s *next;
	char *name;
	unsigned int v;
};

struct sym_s *syms;

int
add_sym(int memory, char *name, int v)
{
	struct sym_s *s;

	if (memory != 1)
		return 0;

	s = (struct sym_s *)malloc(sizeof(struct sym_s));
	if (s) {
		s->name = strdup(name);
		s->v = v;

		s->next = syms;
		syms = s;
	}

	return 0;
}

char *
find_sym_by_val(int memory, int v)
{
	struct sym_s *s;

	if (memory != 1)
		return 0;

	for (s = syms; s; s = s->next) {
		if (s->v == v)
			return s->name;
	}

	return 0;
}

int
find_sym(int memory, char *name, int *pval)
{
	struct sym_s *s;

	if (memory != 1)
		return 0;

	for (s = syms; s; s = s->next) {
		if (strcasecmp(name, s->name) == 0) {
			*pval = s->v;
			return 0;
		}
	}

	return -1;
}

static int
getword(char **pp, char *word, int size)
{
	char *p = *pp;

	if (*p == ')' || *p == '(') {
		*word++ = *p++;
	} else {
		while (*p && *p != ' ' && *p != '\t' && *p != ')') {
			if (size > 0) {
				*word++ = *p;
				size--;
			}
			p++;
		}
	}

	while (*p && (*p == ' ' || *p == '\t'))
		p++;

	*word++ = 0;
	*pp = p;

	return 0;
}

int
symbol36_mic_sym_filename(char *filename)
{
	sym_file = strdup(filename);
	return 0;
}

int
symbol36_setup(void)
{
	FILE *sf;
	int memory;
	char line[256];

	if (sym_file == NULL) {
		sym_file = strdup("3640-mic.sym.~430~");
	}

	sf = fopen(sym_file, "r");
	if (sf == NULL) {
		perror(sym_file);
		return -1;
	}

	memory = 0;

	/* don't tell anyone I parsed lisp code this way */
	while (fgets(line, sizeof(line), sf)) {
		if (line[0] == ';')
			continue;

		if (line[0] == '(') {
			if (memcmp(line+1, "A-MEMORY", 8) == 0)
				memory = 1;
			if (memcmp(line+1, "B-MEMORY", 8) == 0)
				memory = 2;
			if (memcmp(line+1, "C-MEMORY", 8) == 0)
				memory = 3;
		}

		if (line[0] == ' ' && line[1] == '(') {
			char name[64], dot[64], val[64];
			int v;
			char *p;

			p = &line[2];
			getword(&p, name, sizeof(name));
			getword(&p, dot, sizeof(dot));
			getword(&p, val, sizeof(val));
			sscanf(val, "%o", &v);

			if (memory == 1 && 0) {
				printf("%s %o\n", name, v);
			}

			add_sym(memory, name, v);
		}
	}

	fclose(sf);
	return 0;
}

