/*
 * $Id: ldebug.c,v 1.2 2004/07/07 09:52:20 brad Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "lsim.h"

extern u_long sim_pc;
extern int stack_pointer;
extern int frame_pointer;

extern int flag_enter_debugger;
extern char *flag_init_debugger;

int
show_loc(unsigned long addr, int flags)
{
	w36 v;

	read_mem_36(addr, &v);

	if ((addr >> 12) == 0x5ffff) {
		char *sym;
		extern char *find_sym_by_val(int, int);

		sym = find_sym_by_val(1, addr & 0x0fff);
		if (sym) {
			printf("%s ", sym);
		}
	} else {
		char *sym;
		extern char *fep_communication_area_names[];
		extern int fep_communication_area_entries;
		extern char *system_communication_area_names[];
		extern int system_communication_area_entries;

		sym = 0;

		if (addr >= 0 && addr <= fep_communication_area_entries) {
			sym = fep_communication_area_names[addr];
		}
		if (addr >= 0400 && addr <= 0400 + system_communication_area_entries) {
			sym = system_communication_area_names[addr - 0400];
		}
		if (sym) {
			printf("%s ", sym);
		}
	}

	printf("%4o ", addr);

	printf("%02x:%08x ", v.tag, v.word);
	printf("%3o:%011o ", v.tag, v.word);

	show_tagged_loc(addr, "", 0);
}

static int
getaddr(char *str, unsigned long *pa)
{
	if (str == NULL)
		return -1;

	if (str[0] == '0' && str[1] == 'x') {
		sscanf(str+2, "%x", pa);
		*pa = a28(*pa);
		return 0;
	}

	if (str[0] == '0') {
		sscanf(str, "%o", pa);
		*pa = a28(*pa);
		return 0;
	}

	sscanf(str, "%d", pa);
	*pa = a28(*pa);
	return 0;
}

int
interp_debugger(void *stream, char *line)
{
	char *cmd, *astr;
	unsigned long addr;
	int fpn;

	if (line[0] == '#')
		return 0;

#define DELIMS " \t\n"
#define a28(a)		((a) & 0x0fffffff)

	cmd = strtok(line, DELIMS);
	if (cmd == 0)
		return -1;

	if (strcmp(cmd, "quit") == 0 || strcmp(cmd, "q") == 0) {
		exit(0);
	}

	/* show amem */
	if (strcmp(cmd, "a") == 0) {
		astr = strtok(NULL, DELIMS);
		if (getaddr(astr, &addr))
			return -1;

		addr |= 0x5ffff << 12;

		show_loc(addr, 0);
	}

	if (strcmp(cmd, "cf") == 0) {
		astr = strtok(NULL, DELIMS);
		if (getaddr(astr, &addr))
			return -1;

		show_compiled_function(addr);
	}

	if (strcmp(cmd, "d") == 0) {
		astr = strtok(NULL, DELIMS);
		if (getaddr(astr, &addr))
			return -1;

		show_loc(addr, 0);
	}

	if (strcmp(cmd, "dm") == 0) {
		astr = strtok(NULL, DELIMS);
		if (getaddr(astr, &addr))
			return -1;

		fpn = find_vma_map_fpn(a28(addr));
		addr = a28(addr) & 0xffffff00;

		show_page_36(stream, addr, fpn, 2);
	}

	if (strcmp(cmd, "di") == 0) {
		astr = strtok(NULL, DELIMS);
		if (getaddr(astr, &addr))
			return -1;

		fpn = find_vma_map_fpn(a28(addr));
		addr = a28(addr) & 0xffffff00;

		show_page_36(stream, addr, fpn, 4);
	}

	if (strcmp(cmd, "ds") == 0) {
		dump_stack();
	}

	if (strcmp(cmd, "dsym") == 0) {
	}

	/* show tagged */
	if (strcmp(cmd, "t") == 0) {
		astr = strtok(NULL, DELIMS);
		if (getaddr(astr, &addr))
			return -1;

		show_tagged(stream, addr);
	}


	if (strcmp(cmd, "run") == 0) {
		flag_enter_debugger = 0;
		set_trace(1);
		return 1;
	}

	if (strcmp(cmd, "trace") == 0) {
		flag_enter_debugger = 0;
		set_trace(2);
		return 1;
	}

	/* step */
	if (strcmp(cmd, "s") == 0) {
		return 1;
	}

	return 0;
}

void
start_debugger(void *stream)
{
	FILE *f;
	char line[256];

	if (flag_init_debugger) {
		f = fopen(flag_init_debugger, "r");
		if (f) {
			while (fgets(line, sizeof(line), stdin)) {
				interp_debugger(stream, line);
			}

			fclose(f);
		}
	}
}

void
enter_debugger(void *stream)
{
	int ret;
	char line[256];

	printf("\ntop; pc %o, sp %o, fp %o\n",
	       sim_pc >> 1, stack_pointer, frame_pointer);

	while (1) {
		printf("debug> "); fflush(stdout);
		fgets(line, sizeof(line), stdin);
		ret = interp_debugger(stream, line);
		if (ret > 0)
			break;
	}
}

