#include <stdio.h>
#include <stdlib.h>
#include <memory.h>

typedef unsigned char u8;

#define MAX_FLASH (64*1024*1024)

u8 flash[MAX_FLASH];
int flash_size;
unsigned int lowest;
unsigned int highest;

unsigned int csv;

char tohex(char b)
{
    b = b & 0xf;
    if (b < 10) return '0' + b;
    return 'a' + (b - 10);
}

void
dumpmem(char *ptr, int len)
{
    char line[80], chars[80], *p, b, *c, *end;
    int i, j, offset;

    end = ptr + len;
    offset = 0;
    while (ptr < end) {

	p = line;
	c = chars;
	printf("%08x ", (unsigned int)offset);

	*p++ = ' ';
	for (j = 0; j < 16; j++) {
		if (ptr < end) {
			b = *ptr++;
			*p++ = tohex(b >> 4);
			*p++ = tohex(b);
			*p++ = ' ';
			*c++ = ' ' <= b && b <= '~' ? b : '.';
		} else {
			*p++ = 'x';
			*p++ = 'x';
			*p++ = ' ';
			*c++ = 'x';
		}
		offset += 16;
	}
	*p = 0;
	*c = 0;
        printf("%s %s\n", line, chars);
    }
}

static inline 
unhex(char c)
{
	if ('0' <= c && c <= '9') return c - '0';
	if ('A' <= c && c <= 'F') return c - 'A' + 10;
	if ('a' <= c && c <= 'f') return c - 'a' + 10;
	return 0;
}

static inline unsigned int
unbyte(char c1, char c2)
{
	unsigned int v;
	v = (unhex(c1) << 4) | unhex(c2);
	csv += v;
	return v;
}

static inline void
putflash(unsigned int a, u8 v)
{
	if (0) printf("flash[0x%x] = 0x%x\n", a, v);
	flash[a] = v;
	if (a < lowest)
		lowest = a;
	if (a > highest)
		highest = a;
}

void
process_srec(char *line)
{
	unsigned int i, a, bc, cs, v, the_cs;
	int o;

	if (line[0] != 'S')
		return;

	csv = 0;
	bc = unbyte(line[2], line[3]);
	
	switch (line[1]) {
	case '0':
		break;
	case '3':
		a =
			(unbyte(line[4],  line[5]) << 24) |
			(unbyte(line[6],  line[7]) << 16) |
			(unbyte(line[8],  line[9]) <<  8) |
			(unbyte(line[10], line[11]) << 0);

		o = 12;
		for (i = 0; i < bc - 5; i++) {
			v = unbyte(line[o], line[o+1]);
			putflash(a, v);
			o += 2;
			a++;
		}

		the_cs = ~csv & 0xff;

		cs = unbyte(line[o], line[o+1]);
		if (cs != the_cs) {
			fprintf(stderr, "bad checksum %x %x\n",
				cs, the_cs);
			fprintf(stderr, "%s\n", line);
			exit(1);
		}

		break;
	default:
		fprintf(stderr, "unknown srec format\n");
		fprintf(stderr, "%s\n", line);
		exit(1);
	}


}

void
add(char *fn)
{
	FILE *f;
	char line[1024];

	f = fopen(fn, "r");
	if (f) {
		while (fgets(line, sizeof(line), f))
			process_srec(line);
		fclose(f);
	}
}

void
dumpit(void)
{
	if (flash_size > 0) {
		write(1, flash, flash_size);
	}
}

int
main(int argc, char *argv[])
{
	int i, showdump;

	lowest = 0xffffffff;
	highest = 0;
	showdump = 0;

	flash_size = 0x4000000;
	memset(flash, 0xff, flash_size);

	for (i = 1; i < argc; i++) {
		if (argv[i][0] == '-') {
			switch (argv[i][1]) {
			case 'd':
				showdump = 1;
				break;
			}
		} else
			add(argv[i]);
	}

	fprintf(stderr, "flash range %08x-%08x\n", lowest, highest);

	fprintf(stderr, "flash size %d bytes (%dK, %dMbytes)\n",
		0x4000000, 0x4000000 / 1024, 0x4000000 / (1024*1024));

	if (showdump) {
		dumpmem(flash + lowest, highest - lowest + 1);
	}

	if (!showdump) {
		dumpit();
	}

	exit(0);
}
