/**************************************************************************** 
                                  elfmisc.c                                   
                              ------------------                              
    date            : May 2003                                               
    copyright       : Institut de Recherche en Informatique de Toulouse       
    author          : Marc Finet                                              
    email           : finet@irit.fr, sainrat@irit.fr                        
 ****************************************************************************/
                                                                              
/**************************************************************************** 
 *                                                                          * 
 *   This program is free software; you can redistribute it and/or modify   * 
 *   it under the terms of the GNU General Public License as published by   * 
 *   the Free Software Foundation; either version 2 of the License, or      * 
 *   (at your option) any later version.                                    * 
 *                                                                          * 
 ****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "elfmisc.h"

int16_t
ConvertByte2( int16_t Word )
{
    union{
        unsigned char c[2];
        int16_t i;
    }w1,w2;
    
    w1.i = Word;
    w2.c[0] = w1.c[1];
    w2.c[1] = w1.c[0];
    return (w2.i);
}

int32_t
ConvertByte4( int32_t Dword )
{
    union{
        unsigned char c[4];
        int32_t i;
    }dw1,dw2;
    
    dw1.i = Dword;
    dw2.c[0] = dw1.c[3];
    dw2.c[1] = dw1.c[2];
    dw2.c[2] = dw1.c[1];
    dw2.c[3] = dw1.c[0];
    return (dw2.i);
}
