/*
 * loader.c
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include "elf.h"
#include "elfread.h"

struct text_info Text;
struct data_info Data;

int
load(char *elffilename)
{
    char *prog;
    struct data_secs *d_sec;
    struct text_secs *t_sec;
    int elf;

    elf = open(elffilename, O_RDONLY);
    if (elf < 0) {
        perror(elffilename);
        return -1;
    }

    ElfRead(elf);

    close(elf);

    /*
     * need to load:
     * .text
     * .rodata
     * .data
     * .got
    */

    /* load text sections */
    t_sec = Text.secs;
    while (t_sec) {
        printf("text write %08x %d\n", t_sec->address, t_sec->size);
        mem_move_i(t_sec->address, t_sec->bytes, t_sec->size);
        t_sec = t_sec->next;
    }

    /* load data sections */
    d_sec = Data.secs;
    while (d_sec) {
        printf("data write %08x %d\n", d_sec->address, d_sec->size);
        mem_move_d(d_sec->address, d_sec->bytes, d_sec->size);
        d_sec = d_sec->next;
    }
}

void
loader_init(void)
{
}


/*
 * Local Variables:
 * indent-tabs-mode:nil
 * c-basic-offset:4
 * End:
*/
