/*
 * simple NIOS-II simulator
 * Brad Parker <brad@heeltoe.com>
 * 12/20/07
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "sim.h"

int trace_mem;

extern char *optarg;

#include <signal.h>

void sigint_handler(int sig)
{
    inst_final_dump();
    jtag_uart_deinit();
    exit(1);
}

void
signal_init(void)
{
    struct sigaction new, old;

    memset((char *)&new, 0, sizeof(new));
    new.sa_handler = sigint_handler;
    sigaction(SIGINT, &new, &old);
}


void
usage(void)
{
    fprintf(stderr, "usage:\n");
    fprintf(stderr, "-f <elf-filename> read nios code from elf-filename\n");
    fprintf(stderr, "-c <max-cycles>\n");
    exit(1);
}

main(int argc, char *argv[])
{
    int c;
    int max_cycles, do_memtest, do_pset, do_show, do_pc;
    char *elf_file_name;
    unsigned int pc;

    do_memtest = 0;
    do_pset = 0;
    do_show = 1;
    trace_mem = 1;
    max_cycles = 200000;
    elf_file_name = "firmware.elf";
    do_pc = 0;

    while (1) {
        if ((c = getopt(argc, argv, "c:f:qs:u")) == -1)
            break;

        switch (c) {
        case 'c':
            max_cycles = atoi(optarg);
            printf("max cycles: %d\n", max_cycles);
            break;
        case 'f':
            elf_file_name = strdup(optarg);
            printf("elf file: %s\n", elf_file_name);
            break;
        case 'q':
            do_show = 0;
            trace_mem = 0;
            break;
        case 's':
            do_pc = 1;
            sscanf(optarg, "%x", &pc);
            break;
        case 'u':
            max_cycles = 0;
            break;
        default:
            usage();
        }
    }

    loader_init();
    load(elf_file_name);

    signal_init();
    disas_init();
    inst_init();
    mem_init();
    timers_init();
    jtag_uart_init();
    enet_init();

    if (do_pc)
        inst_set_pc(pc);

    inst_run(max_cycles, do_show);

    jtag_uart_deinit();

    exit(0);
}


/*
 * Local Variables:
 * indent-tabs-mode:nil
 * c-basic-offset:4
 * End:
*/
