// flash		0x00000000
// flash controller	0x00680800
// uart			0x006810F0
// sdram		0x00800000
//

/*
 * mem.c
 */

#define M32		(32*1024*1024)
#define M8		(8*1024*1024)
#define SDRAM_BASE	0x00800000
#define FLASH_BASE	0x00000000
		
#include <stdio.h>
#include <memory.h>

#include "sim.h"
#include "ops.h"

//u32 i_mem[64*1024];
//u32 d_mem[64*1024];
u32 flash[8*1024*1024];
u32 ddr2[32*1024*1024];

extern u32 pc;
extern int trace_mem;
extern int trace_int;

/* bulk byte based write to memory, used by elf read code */
int
mem_move_i(u32 addr, u8 *bytes, int size)
{
    char *d;
    int offset;

    printf("mem_move_i(addr=%x, bytes=%p, size=%d)\n",
           addr, bytes, size);

//    offset = addr - 0x2f000000;
//    d = (char *)( ((u8 *)i_mem) + offset );
//    memcpy( d, bytes, size );

    offset = addr - SDRAM_BASE;
    memcpy(((u8 *)ddr2) + offset, bytes, size);
}

/* bulk byte based write to data, used by elf read code */
int
mem_move_d(u32 addr, u8 *bytes, int size)
{
    char *d;
    int offset;

    printf("mem_move_d(addr=%x, bytes=%p, size=%d)\n",
           addr, bytes, size); fflush(stdout);

//    offset = addr - 0x3f000000;
//    d = (char *)( ((u8 *)d_mem) + offset );
//    memcpy(d, bytes, size );

    offset = addr - SDRAM_BASE;
    memcpy( ((u8 *)ddr2) + offset, bytes, size );
}

/* cpu read from instruction space */
u32
mem_read_i(u32 pc)
{
    int offset;

    if (0) printf("mem_read_i: %08x\n", pc);

//    if (pc >= 0x2f000000 && pc <=0x2f00ffff) {
//        offset = pc - 0x2f000000;
//        return i_mem[offset/4];
//    }

    if (pc >= SDRAM_BASE && pc < SDRAM_BASE+M32) {
        offset = pc - SDRAM_BASE;
        return ddr2[offset/4];
    }

    printf("** illegal i_mem read %08x\n", pc);

    return 0;
}

/* cpu read from data space */
u32
mem_read_d32(u32 addr)
{
    int offset;
    u32 v;

//    if (addr >= 0x3f000000 && addr <=0x3f00ffff) {
//        offset = addr - 0x3f000000;
//        return d_mem[offset/4];
//    }

    if (addr >= FLASH_BASE && addr < FLASH_BASE+M8) {
        return 0;
    }

    if (addr >= SDRAM_BASE && addr < SDRAM_BASE+M32) {
        /* ddr2 */
        offset = addr - SDRAM_BASE;
        v = ddr2[offset/4];

//        if (addr == 0x0096fb04) {
//            printf("%08x <- ddr2[%x] @ %08x\n", v, addr, pc);
//            trace_int = 1;
//            //set_local_show();
//        }

        if (0) {
            /* induce error */
            if (addr/4 == 5) v = 0;
        }

        if (trace_mem) printf("%08x <- ddr2[%x]\n", v, addr);
        return v;
    }

    switch (addr) {
    case 0x8068100c:
    case 0x80681008:
        break;

        /* jtag uart */
    case 0x806810f0:
    case 0x806810f4:
        return jtag_uart_read(addr);

    case 0x806810f8:
    case 0x806810fc:
        return enet_read(addr);

    case 0x80681108:
    case 0x8068110c:
        return 0;

        /* timer */
    case 0x80681020: /* 0 - status */
    case 0x80681024: /* 1 - control */
    case 0x80681028: /* 2 - l*/
    case 0x8068102c: /* 3 - h */
        return timer_read32((addr & 0x1f) / 4);
        break;
    }

    printf("** illegal d_mem read %08x @ pc %08x\n", addr, pc);

    return 0;
}

u32
mem_read_d16(u32 addr)
{
    u32 v;

#if 1
    if (addr >= SDRAM_BASE && addr < SDRAM_BASE+M32) {
        int offset = addr - SDRAM_BASE;
        return  ((u16 *)ddr2)[offset/2];
    }
#endif

    v = mem_read_d32(addr & 0xfffffffc);
    if (addr & 2)
        return (v >> 16) & 0xffff;
    return v & 0xffff;
}

u32
mem_read_d8(u32 addr)
{
    u32 v;

#if 1
    if (addr >= SDRAM_BASE && addr < SDRAM_BASE+M32) {
        int offset = addr - SDRAM_BASE;
        return  ((u8 *)ddr2)[offset];
    }
#endif

    v = mem_read_d32(addr & 0xfffffffc);
    switch (addr & 3) {
    case 3: return (v >> 24) & 0xff;
    case 2: return (v >> 16) & 0xff;
    case 1: return (v >>  8) & 0xff;
    case 0: return (v >>  0) & 0xff;
    }
}

/* cpu write to data space */
int
mem_write(u32 addr, u32 v, int size)
{
    int offset;

//    if (addr >= 0x3f000000 && addr <=0x3f00ffff) {
//        if (trace_mem) printf("mem[%x] <- %x\n", addr, v);
//        offset = addr - 0x3f000000;
//        switch (size) {
//        case 1: ((u8 *)d_mem)[offset] = v; break;
//        case 2: ((u16 *)d_mem)[offset/2] = v; break;
//        case 4: d_mem[offset/4] = v; break;
//        }
//        return 0;
//    }

    if (addr >= SDRAM_BASE && addr < SDRAM_BASE+M32) {
        /* ddr2 */
//        if (addr == 0x0096fb04) {
//            printf("%08x -> ddr2[%x]\n", v, addr);
//set_local_show();
//        }

        offset = addr - SDRAM_BASE;
        if (trace_mem) printf("ddr2[%x] <- %x\n", addr, v);
        switch (size) {
        case 1: ((u8 *)ddr2)[offset] = v; break;
        case 2: ((u16 *)ddr2)[offset/2] = v; break;
        case 4: ddr2[offset/4] = v; break;
        }
        return 0;
    }

    switch (addr) {
    case 0x80681008:
    case 0x8068100c:
        printf("uart write %08x <- %08x\n", addr, v);
        return 0;

    case 0x806810f0:
    case 0x806810f4:
        return jtag_uart_write(addr, v);

    case 0x806810f8:
    case 0x806810fc:
        return enet_write(addr, v);

    case 0x80681108:
    case 0x8068110c:
        return 0;

    case 0x80681020: /* 0 - status */
    case 0x80681024: /* 1 - control */
    case 0x80681028: /* 2 - l*/
    case 0x8068102c: /* 3 - h */
        return timer_write32((addr & 0x1f) / 4, v);
    }

    printf("** illegal d_mem write %08x (size%d) <- %08x\n", addr, size, v);
    return -1;
}

int
mem_write_d32(u32 addr, u32 v)
{
    return mem_write(addr, v, 4);
}

int
mem_write_d16(u32 addr, u32 v)
{
    return mem_write(addr, v, 2);
}

int
mem_write_d8(u32 addr, u32 v)
{
    return mem_write(addr, v, 1);
}

void
dump_mem(void)
{
    int i, j;

    printf("ddr2:\n");
    for (i = 0;  i < 64; i++) {
        printf("%04x: ", i*8*4);
        for (j = 0; j < 8; j++)
            printf("%08x ", ddr2[i*8+j]);
        printf("\n");
    }

//    printf("sram:\n");
//    for (i = 0;  i < 64; i++) {
//        printf("%04x: ", i*8*4);
//        for (j = 0; j < 8; j++)
//            printf("%08x ", d_mem[i*8+j]);
//        printf("\n");
//    }
}

void
mem_init(void)
{
}


/*
 * Local Variables:
 * indent-tabs-mode:nil
 * c-basic-offset:4
 * End:
*/
