/*
 * timer.c
 */

#include <stdio.h>
#include "sim.h"
#include "ops.h"

struct {
    char run;
    char to;
    char irq;
    u32 control;
    u32 period_l;
    u32 period_h;
    u32 counter_l;
    u32 counter_h;
} timers[2];

void
timer_update(void)
{
    if (timers[0].run) {
        if (timers[0].counter_l == 0 && timers[0].counter_h == 0) {
            if (timers[0].control & 1) {
                timers[0].counter_l = timers[0].period_l;
                timers[0].counter_h = timers[0].period_h;
                if (0) printf("reload %08x %08x\n",
                              timers[0].counter_h, timers[0].counter_l);
                timers[0].counter_h = timers[0].period_h;
            } else
                timers[0].run = 0;

            return;
        }

        //printf("%08x %08x\n", timers[0].counter_h, timers[0].counter_l);
#if 0
        timers[0].counter_l--;
#else
//#define INC 4
#define INC 1
        if (timers[0].counter_l > INC)
            timers[0].counter_l -= INC;
        else
            timers[0].counter_l = 0;
#endif
        if (timers[0].counter_l == 0) {
            if (timers[0].counter_h) {
                timers[0].counter_h--;
                timers[0].counter_l = 0xffff;
            }

            if (timers[0].counter_l == 0 && timers[0].counter_h == 0) {
                timers[0].to = 1;
                if (timers[0].control & 1) {
                    interrupt_generate(timers[0].irq);
                }
            }
        }
    }
}

u32
timer_read32(int offset)
{
    switch (offset) {
    case 0: return (timers[0].run << 1) | timers[0].to;
    case 1: return timers[0].control;
    case 2: return timers[0].period_l;
    case 3: return timers[0].period_h;
    case 4: return timers[0].counter_l;
    case 5: return timers[0].counter_h;
    }
}

int
timer_write32(int offset, u32 v)
{
    if (0) printf("timer_write32 @ %x <- %08x\n", offset, v);

    switch (offset) {
    case 0:
        timers[0].to = 0;
        interrupt_ack(timers[0].irq);
        break;
    case 1:
        timers[0].control = v & 3;
        if ((v & 4) && timers[0].run == 0) {
            timers[0].run = 1;
printf("timer start\n");
        }
        if ((v & 8) && timers[0].run) {
            timers[0].run = 0;
printf("timer stop\n");
        }
        break;
    case 2:
        timers[0].period_l = timers[0].counter_l = v & 0xffff;
        timers[0].counter_h = timers[0].period_h;
        timers[0].run = 0;
printf("timer load low\n");
        break;
    case 3:
        timers[0].period_h = timers[0].counter_h = v & 0xffff;
        timers[0].counter_l = timers[0].period_l;
        timers[0].run = 0;
printf("timer load high\n");
        break;
    case 4: timers[0].counter_l = v & 0xffff; break;
    case 5: timers[0].counter_h = v & 0xffff; break;
    }

    return 0;
}

void
timer_init(int which, int irq)
{
    timers[which].irq = irq;
}

void
timers_init(void)
{
    timer_init(0, 3);
    timer_init(1, 4);
}

/*
 * Local Variables:
 * indent-tabs-mode:nil
 * c-basic-offset:4
 * End:
*/
