#include <stdio.h>
#include "sim.h"
#include "ops.h"

char *opname[256];

/*
 * ra = r31
 *
 * sp = r27
 * gp = r26
 */

extern u32 reg[32];

void
disas(u32 pc, u32 isn)
{
    u32 op, opx, opx2;
    u32 a, b, c;
    s16 imm16;
    u8 imm5;
    u32 imm26, addr;

    printf("%08x: %08x ", pc, isn);

    op = isn & 0x3f;
    if (opname[op]) {
        if (opname[op][0])
            printf("%s ", opname[op]);
        switch (op) {

        case inst_call:	/* J type */
        case inst_jmpi:
            imm26 = (isn >> 6) & 0x03ffffff;
            pc = (pc & 0xf0000000) | (imm26 << 2);
            printf("0x%x(pc)	; 0x%08x", imm26, pc);
        break;

        case inst_orhi:
        case inst_xorhi:
        case inst_andhi:
            a = (isn >> 27) & 0x1f;
            b = (isn >> 22) & 0x1f;
            imm16 = (isn >> 6) & 0xffff;
            printf("r%d, r%d, 0x%04x", a, b, imm16);
            break;

        case inst_addi:
        case inst_muli:
        case inst_andi:
        case inst_ori:
        case inst_xori:
        case inst_cmpgei:
        case inst_cmplti:
        case inst_cmpnei:
        case inst_cmpeqi:
        case inst_cmpgeui:
        case inst_cmpltui:
            a = (isn >> 27) & 0x1f;
            b = (isn >> 22) & 0x1f;
            imm16 = (isn >> 6) & 0xffff;
            printf("r%d, r%d, 0x%x", b, a, imm16 );
            break;

        case inst_ldw:
        case inst_ldbu:
        case inst_ldb:
        case inst_ldhu:
        case inst_ldh:
        case inst_stw:
        case inst_sth:
        case inst_ldbuio:
        case inst_stbio:
        case inst_ldbio:
        case inst_ldhuio:
        case inst_sthio:
        case inst_ldhio:
        case inst_stwio:
        case inst_ldwio:
            a = (isn >> 27) & 0x1f;
            b = (isn >> 22) & 0x1f;
            imm16 = (isn >> 6) & 0xffff;
            addr = reg[a] + imm16;
            printf("r%d, 0x%x(r%d)	; 0x%08x", b, imm16, a, addr);
            break;

        case inst_blt:
        case inst_bltu:
        case inst_bne:
        case inst_beq:
        case inst_bge:
        case inst_bgeu:
            a = (isn >> 27) & 0x1f;
            b = (isn >> 22) & 0x1f;
            imm16 = (isn >> 6) & 0xffff;
            pc = (pc + 4) + imm16;
            printf("r%d, r%d, 0x%x(pc)	; %08x", a, b, imm16, pc);
            break;

        case inst_br:
            imm16 = (isn >> 6) & 0xffff;
            pc = (pc + 4) + imm16;
            printf("0x%x(pc)	; %08x", imm16, pc);
            break;

        case inst_R_type: /* R-type */
            a = (isn >> 27) & 0x1f;
            b = (isn >> 22) & 0x1f;
            c = (isn >> 17) & 0x1f;
            opx = (isn >> 6) & 0x7ff;
            opx2 = (isn >> 11) & 0x3f;
            imm5 = (isn >> 6) & 0x1f;
            switch (opx2) {
            case 0x01: /* eret */
                printf("eret");
                break;
            case 0x02: /* roli */
                printf("roli r%d, r%d, %d", c, a, imm5);
                break;
            case 0x03: /* rol */
                printf("roli r%d, r%d, r%d	; %d", c, a, b, reg[b]&0xf);
                break;
            case 0x04: /* flushp */
                printf("flushp");
                break;
            case 0x05: /* ret */
                printf("ret");
                break;
            case 0x06: /* nor */
                printf("nor r%d, r%d, r%d", c, a, b);
                break;
            case 0x07: /* mulxuu */
                printf("mulxuu r%d, r%d, %d", c, a, imm5);
                break;
            case 0x08:
                printf("cmpge r%d, r%d, r%d", c, a, b);
                break;
            case 0x09: /* bret */
                printf("bret");
                break;
            case 0x0b: /* ror */
                printf("ror r%d, r%d, r%d", c, a, b);
                break;
            case 0x0c: /* flushi */
                printf("flushi r%d", a);
                break;
            case 0x0d: /* jmp */
                printf("jmp r%d", a);
                break;
            case 0x0e: /* and */
                printf("and r%d, r%d, r%d", c, a, b);
                break;
            case 0x10:
                printf("cmplt r%d, r%d, r%d", c, a, b);
                break;
            case 0x12: /* slli */
                printf("slli r%d, r%d, %d", c, a, imm5);
                break;
            case 0x13: /* sll */
                printf("sll r%d, r%d, r%d	; %d", c, a, b, reg[b] & 0x1f);
                break;
            case 0x16: /* or */
                printf("or r%d, r%d, r%d", c, a, b);
                break;
            case 0x17: /* mulxsu */
                printf("mulxsu r%d, r%d, %d", c, a, imm5);
                break;
            case 0x18:
                printf("cmpne r%d, r%d, r%d", c, a, b);
                break;
            case 0x1a: /* srli */
                printf("srli r%d, r%d, %d", c, a, imm5);
                break;
            case 0x1b: /* srl */
                printf("srl r%d, r%d, r%d	; %d", c, a, b, reg[b] & 0x1f);
                break;
            case 0x1c: /* nextpc */
                printf("nextpc r%d", c/*a*/);
                break;
            case 0x1d: /* callr */
                printf("callr r%d", a);
                break;
            case 0x1e: /* xor */
                printf("xor r%d, r%d, r%d", c, a, b);
                break;
            case 0x1f: /* mulxss */
                printf("mulxss r%d, r%d, %d", c, a, imm5);
                break;
            case 0x20:
                printf("cmpeq r%d, r%d, r%d", c, a, b);
                break;
            case 0x24: /* divu */
                printf("divu r%d, r%d, r%d", c, a, b);
                break;
            case 0x25: /* div */
                printf("div r%d, r%d, r%d", c, a, b);
                break;
            case 0x26:
                printf("rdctl r%d, %d", c, imm5);
                break;
            case 0x27:
                printf("mul r%d, r%d, r%d", c, a, b);
                break;
            case 0x28:
                printf("cmpgeu r%d, r%d, r%d", c, a, b);
                break;
            case 0x29: /* initi */
                printf("initi r%d", a);
                break;
            case 0x2d: /* trap */
                printf("trap");
                break;
            case 0x2e: /* wrctl */
                printf("wrctl %d, r%d", imm5, a);
                break;
            case 0x30:
                printf("cmpltu r%d, r%d, r%d", c, a, b);
                break;
            case 0x31: /* add */
                printf("add r%d, r%d, r%d", c, a, b);
                break;
            case 0x34: /* add */
                printf("break 0x%x", imm5);
                break;
            case 0x36: /* sync */
                printf("sync");
                break;
            case 0x39:
                printf("sub r%d, r%d, r%d", c, a, b);
                break;
            case 0x3a: /* srai */
                printf("srai r%d, r%d, %d", c, a, imm5);
                break;
            case 0x3b: /* sra */
                printf("sra r%d, r%d, r%d	; %d", c, a, b, reg[b] & 0x1f);
                break;
            default:
                printf("(op %x %x) r%d, r%d, r%d", opx, opx2,c, a, b);
                break;
            }
        }
    }

    printf("\n");
}

void
disas_opcodes(void)
{
    opname[inst_call] = "call";
    opname[inst_jmpi] = "jmpi";
    opname[inst_ldbu] = "ldbu";
    opname[inst_addi] = "addi";
    opname[inst_stb] = "stb";
    opname[inst_br] = "br";
    opname[inst_ldb] = "ldb";
    opname[inst_cmpgei] = "cmpgei";
    opname[inst_ldhu] = "ldhu";
    opname[inst_andi] = "andi";
    opname[inst_sth] = "sth";
    opname[inst_bge] = "bge";
    opname[inst_ldh] = "ldh";
    opname[inst_cmplti] = "cmplti";
    opname[inst_ori] = "ori";
    opname[inst_stw] = "stw";
    opname[inst_blt] = "blt";
    opname[inst_ldw] = "ldw";
    opname[inst_cmpnei] = "cmpnei";
    opname[inst_flushda] = "flushda";
    opname[inst_xori] = "xori";
    opname[inst_bne] = "bne";
    opname[inst_cmpeqi] = "cmpeqi";
    opname[inst_ldbuio] = "ldbuio";
    opname[inst_muli] = "muli";
    opname[inst_stbio] = "stbio";
    opname[inst_beq] = "beq";
    opname[inst_ldbio] = "ldbio";
    opname[inst_cmpgeui] = "cmpgeui";
    opname[inst_ldhuio] = "ldhuio";
    opname[inst_andhi] = "andhi";
    opname[inst_sthio] = "sthio";
    opname[inst_bgeu] = "bgeu";
    opname[inst_ldhio] = "ldhio";
    opname[inst_cmpltui] = "cmpltui";
    opname[inst_custom] = "custom";
    opname[inst_initd] = "initd";
    opname[inst_orhi] = "orhi";
    opname[inst_stwio] = "stwio";
    opname[inst_bltu] = "bltu";
    opname[inst_ldwio] = "ldwio";
    opname[inst_R_type] = "";
    opname[inst_flushd] = "flushd";
    opname[inst_xorhi] = "xorhi";
}

void
disas_init(void)
{
    disas_opcodes();
}




/*
 * Local Variables:
 * indent-tabs-mode:nil
 * c-basic-offset:4
 * End:
*/
