/**************************************************************************** 
                                 elfconvert.c                                 
                              ------------------                              
    date            : May 2003                                               
    copyright       : Institut de Recherche en Informatique de Toulouse       
    author          : Marc Finet                                              
    email           : finet@irit.fr, sainrat@irit.fr                        
 ****************************************************************************/
                                                                              
/**************************************************************************** 
 *                                                                          * 
 *   This program is free software; you can redistribute it and/or modify   * 
 *   it under the terms of the GNU General Public License as published by   * 
 *   the Free Software Foundation; either version 2 of the License, or      * 
 *   (at your option) any later version.                                    * 
 *                                                                          * 
 ****************************************************************************/

#include <stdio.h>
#include <fcntl.h>
#include "elf.h"
#include "elfmisc.h"

void
ConvertElfHeader(Elf32_Ehdr *Ehdr)
{
    Ehdr->e_type = ConvertByte2(Ehdr->e_type);
    Ehdr->e_machine = ConvertByte2(Ehdr->e_machine);
    Ehdr->e_version = ConvertByte4(Ehdr->e_version);
    Ehdr->e_entry = ConvertByte4(Ehdr->e_entry);
    Ehdr->e_phoff = ConvertByte4(Ehdr->e_phoff);
    Ehdr->e_shoff = ConvertByte4(Ehdr->e_shoff);
    Ehdr->e_flags = ConvertByte4(Ehdr->e_flags);
    Ehdr->e_ehsize = ConvertByte2(Ehdr->e_ehsize);
    Ehdr->e_phentsize = ConvertByte2(Ehdr->e_phentsize);
    Ehdr->e_phnum = ConvertByte2(Ehdr->e_phnum);
    Ehdr->e_shentsize = ConvertByte2(Ehdr->e_shentsize);
    Ehdr->e_shnum = ConvertByte2(Ehdr->e_shnum);
    Ehdr->e_shstrndx = ConvertByte2(Ehdr->e_shstrndx);
}

void
ConvertSecHeader(Elf32_Shdr *Eshdr)
{
    Eshdr->sh_name = ConvertByte4(Eshdr->sh_name);
    Eshdr->sh_type = ConvertByte4(Eshdr->sh_type);
    Eshdr->sh_flags = ConvertByte4(Eshdr->sh_flags);
    Eshdr->sh_addr = ConvertByte4(Eshdr->sh_addr);
    Eshdr->sh_offset = ConvertByte4(Eshdr->sh_offset);
    Eshdr->sh_size = ConvertByte4(Eshdr->sh_size);
    Eshdr->sh_link = ConvertByte4(Eshdr->sh_link);
    Eshdr->sh_info = ConvertByte4(Eshdr->sh_info);
    Eshdr->sh_addralign = ConvertByte4(Eshdr->sh_addralign);
    Eshdr->sh_entsize = ConvertByte4(Eshdr->sh_entsize);
}

void
ConvertPgmHeader(Elf32_Phdr *Ephdr)
{
    Ephdr->p_type = ConvertByte4(Ephdr->p_type);	
    Ephdr->p_offset = ConvertByte4(Ephdr->p_offset);	
    Ephdr->p_vaddr = ConvertByte4(Ephdr->p_vaddr);	
    Ephdr->p_paddr = ConvertByte4(Ephdr->p_paddr);	
    Ephdr->p_filesz = ConvertByte4(Ephdr->p_filesz);	
    Ephdr->p_memsz = ConvertByte4(Ephdr->p_memsz);	
    Ephdr->p_flags = ConvertByte4(Ephdr->p_flags);	
    Ephdr->p_align = ConvertByte4(Ephdr->p_align);	
}

void
ConvertSymTblEnt(Elf32_Sym *Esym)
{
    Esym->st_name = ConvertByte4(Esym->st_name);
    Esym->st_value = ConvertByte4(Esym->st_value);
    Esym->st_size = ConvertByte4(Esym->st_size);
    Esym->st_shndx = ConvertByte2(Esym->st_shndx);
}


/*
 * Local Variables:
 * indent-tabs-mode:nil
 * c-basic-offset:4
 * End:
*/
