/*
 * enet.c
 */

#include <stdio.h>
#include <termios.h>
#include <sys/poll.h>

#include "sim.h"

/*
 * 6    DM9000A_avalon_slave_0_irq_from_sa,
 */

#define DM9000_ID		0x90000A46

#define DM9000_NCR             0x00
#define DM9000_NSR             0x01
#define DM9000_TCR             0x02


#define DM9000_EPCR            0x0B
#define DM9000_EPAR            0x0C
#define DM9000_EPDRL           0x0D
#define DM9000_EPDRH           0x0E

#define DM9000_VIDL            0x28
#define DM9000_VIDH            0x29
#define DM9000_PIDL            0x2A
#define DM9000_PIDH            0x2B

#define DM9000_TXPLL           0xFC
#define DM9000_TXPLH           0xFD
#define DM9000_ISR             0xFE

int enet_reg;
u8 enet_regs[256];
int enet_srom_addr;
u16 enet_srom[256];

#define NSR_TX2END          (1<<3)
#define NSR_TX1END          (1<<2)

#define TCR_TXREQ           (1<<0)

u8 enet_pkt[1600];
int enet_pkt_ptr;

void
enet_read_reg(void)
{
    //printf("enet reg addr %x\n", enet_reg);
    switch (enet_reg) {
    case DM9000_NSR:
        enet_regs[DM9000_NSR] = 0;
        //enet_regs[DM9000_NSR] = NSR_TX2END | NSR_TX1END;
        break;
    case DM9000_EPAR:
        break;
    case DM9000_ISR:
//	if (int_status & ISR_PRS)
//	if (int_status & ISR_PTS)
        break;
    }
}

void
enet_write_reg(u32 v)
{
    switch (enet_reg) {
    case DM9000_EPAR:
        enet_srom_addr = v;
printf("epar %x\n", v);
        break;
    case DM9000_EPCR:
printf("epcr %x\n", v);
printf("enet read srom %x -> %x %x\n", enet_srom_addr, enet_srom[enet_srom_addr], v);
	enet_regs[DM9000_EPDRL] = enet_srom[enet_srom_addr];
	enet_regs[DM9000_EPDRH] = enet_srom[enet_srom_addr] >> 8;
        break;

    case DM9000_TXPLL:
printf("enet txpll\n");
        enet_pkt[enet_pkt_ptr++] = v;
        break;
    case DM9000_TXPLH:
        enet_pkt[enet_pkt_ptr++] = v;
        break;

    case DM9000_TCR:
printf("enet tcr %08x\n", v);
        if (v & TCR_TXREQ) {
printf("enet tx!\n");
            enet_pkt_ptr = 0;
        }
    }
}

u32
enet_read(u32 addr)
{
    int offset = addr & 0xf;

    //printf("enet read %08x\n", addr);
    switch (offset) {
    case 0x8:
        return enet_reg;
        break;
    case 0xc:
        //printf("enet reg %x -> %x\n", enet_reg, enet_regs[enet_reg]);
        return enet_regs[enet_reg];
        break;
    }

    return 0;
}

u32
enet_write(u32 addr, u32 v)
{
    int offset = addr & 0xf;

    //printf("enet write %08x <- %08c\n", addr, v);
    switch (offset) {
    case 0x8:
        enet_reg = v & 0xff;
        enet_read_reg();
        break;
    case 0xc:
        enet_write_reg(v);
        break;
    }

    return 0;
}

void
enet_init(void)
{
    enet_regs[DM9000_VIDL] = (u8)(DM9000_ID >> 0);
    enet_regs[DM9000_VIDH] = (u8)(DM9000_ID >> 8);
    enet_regs[DM9000_PIDL] = (u8)(DM9000_ID >> 16);
    enet_regs[DM9000_PIDH] = (u8)(DM9000_ID >> 24);

    enet_srom[0] = 0x0102;
    enet_srom[1] = 0x0304;
    enet_srom[2] = 0x0506;
}


/*
 * Local Variables:
 * indent-tabs-mode:nil
 * c-basic-offset:4
 * End:
*/

