#include <stdio.h>
#include <fcntl.h>
#include <memory.h>

#include "sim.h"
#include "ops.h"

static struct {
	u32 addr;
	u16 data;
} wbus[6];
static int wcnt;

#if 0
#define MAX_QUERY 0x4d
static u16 query[0x4d] = {
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, /* 0 - 4 */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, /* 5 - 9 */
	0x0000, 0x0000, 0x0000, 0x0000, 0x0000, /* a - e */
	0x0000,					/* f */

	0x0051, 0x0052, 0x0059,			/* 10 - 12 : QRY*/
	0x0002, 0x0000,				/* 13 - 14 */
	0x0040, 0x0000,				/* 15 - 16 */
	0x0000, 0x0000,				/* 17 - 18 */
	0x0000, 0x0000,				/* 19 - 1a */

	0x0027,					/* 1b */
	0x0036,					/* 1c */
	0x0000,					/* 1d */
	0x0000,					/* 1e */
	0x0004,					/* 1f */
	0x0000,					/* 20 */
	0x000a,					/* 21 */
	0x0000,					/* 22 */
	0x0005,					/* 23 */
	0x0000,					/* 24 */
	0x0004,					/* 25 */
	0x0000,					/* 26 */

#if 0
	0x0015,					/* 27 : Device Size = 2^N Bytes */
#else
	0x0017,					/* 27 : Device Size = 2^N Bytes */
#endif
	0x0002, 0x0000,				/* 28 - 29 */
	0x0000, 0x0000,				/* 2a - 2b */
	0x0004,					/* 2c */
	0x0000, 0x0000, 0x0040, 0x0000,		/* 2d - 30 */
	0x0001, 0x0000, 0x0020, 0x0000,		/* 31 - 34 */
	0x0000, 0x0000, 0x0080, 0x0000,		/* 35 - 38 */
	0x001e, 0x0000, 0x0000, 0x0001,		/* 39 - 3c */
	0x0000, 0x0000, 0x0000,			/* 3d - 3f */

	0x0050, 0x0052, 0x0049,			/* 40 - 42 : PRI */
	0x0031,					/* 43 */
	0x0030,					/* 44 */
	0x0000,					/* 45 */
	0x0002,					/* 46 */
	0x0001,					/* 47 */
	0x0001,					/* 48 */
	0x0004,					/* 49 */
	0x0000,					/* 4a */
	0x0000,					/* 4b */
	0x0000,					/* 4c */
};

static void init_query(void)
{
}
#endif

#if 1
#define MAX_QUERY 0x47
static u16 query[MAX_QUERY];

static void init_query(void)
{
	query[0x00] = 0x0089;	//manu. ID
	query[0x01] = 0x0018;	//device ID     
	query[0x02] = 0x0001;	//?
	query[0x10] = 0x0051;	//"Q"
	query[0x11] = 0x0052;	//"R"
	query[0x12] = 0x0059;	//"Y"

	query[0x13] = 0x0001;

	query[0x15] = 0x0031;

	query[0x1b] = 0x0027;
	query[0x1c] = 0x0036;
	query[0x1f] = 0x0007;
	query[0x20] = 0x0007;
	query[0x21] = 0x000A;
	query[0x23] = 0x0004;
	query[0x24] = 0x0004;
	query[0x25] = 0x0004;

#if 0
	query[0x27] = 0x0018;	//2^(0x18) = 2^24 = 16MByte 28F128 flash chip size

	query[0x28] = 0x0002;
	query[0x2a] = 0x0005;	//2^5 = 32 write buffer size
	query[0x2c] = 0x0001;	//symmetrically-blocked

	query[0x2d] = 0x007F;	//[31,16]=?(128KByte) ;[15,0]=block number

	query[0x30] = 0x0002;


	query[0x31] = 0x0050;	//"P"
	query[0x32] = 0x0052;	//"R"
	query[0x33] = 0x0049;	//"I"

	query[0x34] = 0x0031;
	query[0x35] = 0x0032;	// *

	query[0x36] = 0x00CE;	// *

	query[0x3a] = 0x0001;

	query[0x3b] = 0x0001;
	query[0x3c] = 0x0001;

	query[0x3d] = 0x0033;
	query[0x3f] = 0x0001;

	query[0x40] = 0x0000;	// +
	query[0x41] = 0x0001;	// +
	query[0x42] = 0x0003;
	query[0x43] = 0x0003;
	query[0x44] = 0x0003;
#else
	query[0x27] = 0x001a;	//2^(0x18) = 2^24 = 16MByte 28F128 flash chip size

	query[0x28] = 0x0002;
	query[0x2a] = 0x0005;	//2^5 = 32 write buffer size
	query[0x2c] = 0x0001;	//symmetrically-blocked

	query[0x2d] = 0x00ff;	//[31,16]=?(128KByte) ;[15,0]=block number
	query[0x2e] = 0x0001;
	query[0x2f] = 0x0000;
	query[0x30] = 0x0002;

	query[0x31] = 0x0050;	//"P"
	query[0x32] = 0x0052;	//"R"
	query[0x33] = 0x0049;	//"I"

	query[0x34] = 0x0031;
	query[0x35] = 0x0032;	// *

	query[0x36] = 0x00CE;	// *

	query[0x3a] = 0x0001;

	query[0x3b] = 0x0001;
	query[0x3c] = 0x0001;

	query[0x3d] = 0x0033;
	query[0x3f] = 0x0001;

	query[0x40] = 0x0000;	// +
	query[0x41] = 0x0001;	// +
	query[0x42] = 0x0003;
	query[0x43] = 0x0003;
	query[0x44] = 0x0003;
#endif
}
#endif

int
flash_active(void)
{
	return wcnt > 0 ? 1 : 0;
}

#define CMD_WCHECK(n, o, v)				\
	(wbus[n].addr == o && wbus[n].data == v)

#define CMD_WORD_QUERY				\
	(wcnt == 1 &&				\
	 CMD_WCHECK(0, 0xaa/*0x55*/, 0x98))

u32
flash_read(u32 addr, int size)
{
	u32 v;

	v = 0;

#if 0
	printf("size %d; wcnt %d, (%x %x) (%x %x)\n",
	       size, wcnt,
	       wbus[0].addr, wbus[0].data, wbus[1].addr, wbus[1].data);
#endif

	if (CMD_WORD_QUERY) {
		int offset = addr/2;
		v = (offset < MAX_QUERY ? *(query + offset) : 0x0);
	}

        if (0) printf("flash read %08x -> %08x; size %d\n", addr, v, size);
	return v;
}

int
flash_write(u32 addr, u32 v, int size)
{
        if (0) printf("flash write %08x <- %08x (size%d)\n", addr, v, size);

	if (size == 2) {
		if (wcnt < 6) {
			wbus[wcnt].addr = addr;
			wbus[wcnt].data = v;
			wcnt++;
		}
		if (v == 0xf0 || v == 0xff) {
			wcnt = 0;
			memset((char *)&wbus, 0, sizeof(wbus));
			init_query();
		}
	}

	return 0;
}
