/*
 * loader.c
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include "elf.h"
#include "elfread.h"

struct text_info Text;
struct data_info Data;

int
load(char *elffilename)
{
    char *prog;
    struct data_secs *d_sec;
    struct text_secs *t_sec;
    int elf;

    elf = open(elffilename, O_RDONLY);
    if (elf < 0) {
        perror(elffilename);
        return -1;
    }

    ElfRead(elf);

    close(elf);

    /*
     * need to load:
     * .text
     * .rodata
     * .data
     * .got
    */

    /* load text sections */
    t_sec = Text.secs;
    while (t_sec) {
        printf("text write %08x %d\n", t_sec->address, t_sec->size);
        mem_move_i(t_sec->address, t_sec->bytes, t_sec->size);
        t_sec = t_sec->next;
    }

    /* load data sections */
    d_sec = Data.secs;
    while (d_sec) {
        printf("data write %08x %d\n", d_sec->address, d_sec->size);
        mem_move_d(d_sec->address, d_sec->bytes, d_sec->size);
        d_sec = d_sec->next;
    }
}

void
loader_init(void)
{
}

static char bootargs[] =
//    "noinitrd rw root=/dev/mtdblock0 rootfstype=jffs2 console=ttyJ0";
    "noinitrd rw root=/dev/mtdblock0 rootfstype=jffs2 console=ttyJ0 init=/bin/sh";

static char initrd[8*1024*1024];

void
uboot_init(void)
{
    unsigned int regs[4];
    int fd, ret;

    /*
     * r4 = 0x534f494e
     * r5 = initrd start
     * r6 = initrd end
     * r7 = command line
     */
    regs[0] = 0x534f494e;
    regs[1] = 0x0;
    regs[2] = 0x0;
    regs[3] = 0xd1000000;

    fd = open("rootfs.initramfs.gz", O_RDONLY);
    if (fd > 0) {
        unsigned int ramdisk;

        ret = read(fd, initrd, sizeof(initrd));
        close(fd);

        ramdisk = 0xd1100000;

        if (ret > 0) {
            regs[1] = ramdisk;
            regs[2] = ramdisk+ret;
            mem_move_d(ramdisk, initrd, ret);
            printf("RAMDISK %x %x\n", regs[1], regs[2]);
        }
    } else
        perror("ramdisk");

    mem_move_d(0xd1000000, bootargs, sizeof(bootargs)+1);

    inst_set_regs(4, 7, regs);
}


/*
 * Local Variables:
 * indent-tabs-mode:nil
 * c-basic-offset:4
 * End:
*/
