#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>

typedef unsigned int u32;

static char initrd[8*1024*1024];

void dumpit(char *buf, int size, int offset)
{
	u32 *p, v;


	p = (u32 *)buf;

	while (size > 0) {
		v = *p++;
		printf("%08x %08x\n", offset, v);
		offset += 4;
		size -= 4;
	}
}


main()
{
	u32 base;
	int fd, ret;

	base = 0xd1100000;

	fd = open("rootfs.initramfs.gz", O_RDONLY);
	if (fd > 0) {
		ret = read(fd, initrd, sizeof(initrd));
		close(fd);

		if (ret > 0) {
			dumpit(initrd, ret, base & 0x1fffffff);
		}
        }

	exit(0);
}
