#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include "elf.h"
#include "elfread.h"

struct text_info Text;
struct data_info Data;

typedef unsigned int u32;
typedef unsigned char u8;

#define M128		(128*1024*1024)
#define SDRAM_BASE	0x10000000

void dumpit(char *buf, int size, int offset)
{
	u32 *p, v;

	p = (u32 *)buf;
	offset &= 0x1fffffff;

	while (size > 0) {
		v = *p++;
		printf("%08x %08x\n", offset, v);
		offset += 4;
		size -= 4;
	}
}

int
dump_i(u32 addr, u8 *bytes, int size)
{
    char *d;
    int offset;

    if (0) printf("mem_move_i(addr=%x, bytes=%x, size=%d)\n",
           addr, (unsigned int)*bytes, size);

//    offset = (addr - SDRAM_BASE) & (M128-1);
    offset = addr;
    dumpit(bytes, size, offset);
}

int
dump_d(u32 addr, u8 *bytes, int size)
{
    char *d;
    int offset;

    if (0) printf("mem_move_d(addr=%x, bytes=%x, size=%d)\n",
           addr, (unsigned int)*bytes, size); fflush(stdout);

//    offset = (addr - SDRAM_BASE) & (M128-1);
    offset = addr;
    dumpit(bytes, size, offset);
}

int dump_elf(char *elffilename)
{
    char *prog;
    struct data_secs *d_sec;
    struct text_secs *t_sec;
    int elf;

    elf = open(elffilename, O_RDONLY);
    if (elf < 0) {
        perror(elffilename);
        return -1;
    }

    ElfRead(elf);

    close(elf);

    /*
     * need to load:
     * .text
     * .rodata
     * .data
     * .got
    */

    /* load text sections */
    t_sec = Text.secs;
    while (t_sec) {
	    if (0) printf("text write %08x %d\n", t_sec->address, t_sec->size);
	    dump_i(t_sec->address, t_sec->bytes, t_sec->size);
	    t_sec = t_sec->next;
    }

    /* load data sections */
    d_sec = Data.secs;
    while (d_sec) {
	    if (0) printf("data write %08x %d\n", d_sec->address, d_sec->size);
	    dump_d(d_sec->address, d_sec->bytes, d_sec->size);
	    d_sec = d_sec->next;
    }

    return 0;
}

main()
{
	dump_elf("vmlinux");
}
