#include "svdpi.h"
//#include "Vtest_bench__Dpi.h"

#include <stdio.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * 
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <fcntl.h>

#ifdef unix
#include <unistd.h>
#endif

typedef unsigned int u32;
typedef unsigned short u16;

char last_rd_bit;
char last_wr_bit;
u32 last_read;

static struct state_s {
    u32 flash[16*1024*1024];
    int file_inited;
} state;


static void
do_flash_setup(struct state_s *s)
{
    int fd, ret;

    printf("flash: setup\n");

    fd = open("flash.img", O_RDONLY);

    if (fd >= 0) {
        ret = read(fd, s->flash, sizeof(s->flash));
        if (ret < 0)
            perror("flash.img");
        else {
            printf("flash: %d bytes\n", ret);
        }
        close(fd);
    }

    /* fake u-boot @ 0x2800000; set regs & jmp 0xc0000000 */
    s->flash[0xA00000] = 0x0114d3f4; /* 	movhi	r4,21327	*/
    s->flash[0xA00001] = 0x21125384; /* 	addi	r4,r4,18766	*/
    s->flash[0xA00002] = 0x01400034; /* 	movhi	r5,0		*/
    s->flash[0xA00003] = 0x29400004; /* 	addi	r5,r5,0		*/
    s->flash[0xA00004] = 0x01800034; /* 	movhi	r6,0		*/
    s->flash[0xA00005] = 0x31800004; /* 	addi	r6,r6,0		*/
    s->flash[0xA00006] = 0x01f44034; /* 	movhi	r7,53504	*/
    s->flash[0xA00007] = 0x39c00004; /* 	addi	r7,r7,0		*/
    s->flash[0xA00008] = 0x06340034; /* 	movhi	et,53248	*/
    s->flash[0xA00009] = 0xc6000004; /* 	addi	et,et,0		*/
    s->flash[0xA0000a] = 0xc000683a; /* 	jmp	et		*/
}

static struct {
	u32 addr;
	u16 data;
} wbus[6];
static int wcnt;

#define MAX_QUERY 0x47
static u16 query[MAX_QUERY];

static void init_query(void)
{
	query[0x00] = 0x0089;	//manu. ID
	query[0x01] = 0x0018;	//device ID     
	query[0x02] = 0x0001;	//?
	query[0x10] = 0x0051;	//"Q"
	query[0x11] = 0x0052;	//"R"
	query[0x12] = 0x0059;	//"Y"

	query[0x13] = 0x0001;

	query[0x15] = 0x0031;

	query[0x1b] = 0x0027;
	query[0x1c] = 0x0036;
	query[0x1f] = 0x0007;
	query[0x20] = 0x0007;
	query[0x21] = 0x000A;
	query[0x23] = 0x0004;
	query[0x24] = 0x0004;
	query[0x25] = 0x0004;

	query[0x27] = 0x001a;	//2^(0x1a) = 2^26 = 64MByte 28F512 flash chip size

	query[0x28] = 0x0002;
	query[0x2a] = 0x0005;	//2^5 = 32 write buffer size
	query[0x2c] = 0x0001;	//symmetrically-blocked

	query[0x2d] = 0x00ff;	//[31,16]=?(128KByte) ;[15,0]=block number
	query[0x2e] = 0x0001;
	query[0x2f] = 0x0000;
	query[0x30] = 0x0002;

	query[0x31] = 0x0050;	//"P"
	query[0x32] = 0x0052;	//"R"
	query[0x33] = 0x0049;	//"I"

	query[0x34] = 0x0031;
	query[0x35] = 0x0032;	// *

	query[0x36] = 0x00CE;	// *

	query[0x3a] = 0x0001;

	query[0x3b] = 0x0001;
	query[0x3c] = 0x0001;

	query[0x3d] = 0x0033;
	query[0x3f] = 0x0001;

	query[0x40] = 0x0000;	// +
	query[0x41] = 0x0001;	// +
	query[0x42] = 0x0003;
	query[0x43] = 0x0003;
	query[0x44] = 0x0003;
}

int
flash_active(void)
{
	return wcnt > 0 ? 1 : 0;
}

#define CMD_WCHECK(n, o, v)				\
	(wbus[n].addr == o && wbus[n].data == v)

#define CMD_WORD_QUERY				\
	(wcnt == 1 &&				\
	 CMD_WCHECK(0, 0xaa/*0x55*/, 0x98))

static u32
flash_read(u32 addr, int size)
{
	u32 v;

	v = 0;

#if 1
	printf("dpi_flash: size %d; wcnt %d, (%x %x) (%x %x)\n",
	       size, wcnt,
	       wbus[0].addr, wbus[0].data, wbus[1].addr, wbus[1].data);
#endif

	if (CMD_WORD_QUERY) {
		int offset = addr/2;
		v = (offset < MAX_QUERY ? *(query + offset) : 0x0);
#if 1
		if (1) printf("dpi_flash: query offset %x\n", offset);
#endif
		v = ((v & 0xffff) << 16) | v;
	}

        if (1) printf("flash_read %08x -> %08x; size %d\n", addr, v, size);
	return v;
}

static int
flash_write(u32 addr, u32 v, int size)
{
        if (1) printf("flash_write %08x <- %08x (size%d)\n", addr, v, size);

	if (size == 2) {
		v &= 0x0000ffff;

		if (wcnt < 6) {
			wbus[wcnt].addr = addr;
			wbus[wcnt].data = v;
			wcnt++;
		}
		if (v == 0xf0 || v == 0xff) {
			wcnt = 0;
			memset((char *)&wbus, 0, sizeof(wbus));
			init_query();
		}
	}

	return 0;
}

/*
 *
 */
void dpi_flash(int d_in, int* d_out, int a, int rd, int wr)
{
    struct state_s *s;
    int read_start, read_stop, write_start, write_stop;
    int offset;

    s = &state;

    if (!s->file_inited) {
        s->file_inited = 1;
        do_flash_setup(s);
    }

#if 1
    if ((a & 0xff000000) == 0x10000000) {
	    //printf("dpi_flash: rejecting dram address; a=%08x rd=%d wr=%d\n", a, rd, wr);
	    return;
    }
#endif

    /* */
    read_start = 0;
    read_stop = 0;
    write_start = 0;
    write_stop = 0;

    if (rd != last_rd_bit) {
        if (rd == 1) read_start = 1;
        if (rd == 0) read_stop = 0;
    }

    if (wr != last_wr_bit) {
        if (wr == 1) write_start = 1;
        if (wr == 0) write_stop = 0;
    }

    last_rd_bit = rd;
    last_wr_bit = wr;

    if (1) {
        if (read_start) printf("dpi_flash: read start\n");
        if (read_stop) printf("dpi_flash: read stop\n");
        if (write_start) printf("dpi_flash: write start\n");
        if (write_stop) printf("dpi_flash: write stop\n");
    }

    /* */
    if (write_start) {
        if (1) printf("dpi_flash: write @ %x <- %x\n", a, d_in);

        flash_write(a, d_in & 0xffff, 2);
    }

    if (read_start) {

        if (flash_active())
	    last_read = flash_read(a, 2);
	else {
	    offset = a & 0x03ffffff;
	    last_read = s->flash[offset/4];
	}

	*d_out = last_read;

        if (1) printf("dpi_flash: read @ %x -> %x\n", a, last_read);
    }

    if (!read_start && !write_start && rd == 1) {

        if (flash_active())
	    last_read = flash_read(a, 2);
	else {
	    offset = a & 0x03ffffff;
	    last_read = s->flash[offset/4];
	}

	*d_out = last_read;

        if (1) printf("dpi_flash: read @ %x -> %08x\n", a, last_read);
    }

    if (read_stop) {
    }
}

#ifdef __cplusplus
}
#endif


/*
 * Local Variables:
 * indent-tabs-mode:nil
 * c-basic-offset:4
 * End:
*/

