// test_bench.cpp
//
//

#include <verilated.h>
#include <verilated_vcd_c.h>
#include "Vtest_bench.h"

#include <iostream>

Vtest_bench *top;                      // Instantiation of module

unsigned int main_time = 0;     // Current simulation time

double sc_time_stamp () {       // Called by $time in Verilog
    return main_time;
}

int main(int argc, char** argv)
{
    VerilatedVcdC* tfp = NULL;
    Verilated::commandArgs(argc, argv);   // Remember args

    top = new Vtest_bench;             // Create instance

    if (0) {
	    Verilated::traceEverOn(true);
	    VL_PRINTF("Enabling waves...\n");
	    tfp = new VerilatedVcdC;
	    top->trace(tfp, 99);	// Trace 99 levels of hierarchy
	    tfp->open("test.vcd");	// Open the dump file
    }

    while (!Verilated::gotFinish()) {

	// Resets
	if (main_time < 1000) {
	    if (main_time == 20) {
		    VL_PRINTF("reset on\n");
		    top->v__DOT__reset_n = 0;
	    }
	    if (main_time == 500/*50*/) {
		    VL_PRINTF("reset off\n");
		    top->v__DOT__reset_n = 1;
	    }
	}

	// Toggle clock
	top->v__DOT__clkin_50 = ~top->v__DOT__clkin_50;

	// Evaluate model
        top->eval();

#if 0
        if (top->v__DOT__clk &&
	    top->v__DOT__state == 1)
	{
		VL_PRINTF("pc %o ir %o l%d ac %o ion %o (IF%o DF%o UF%o SF%o IB%o UB%o)\n",
			  top->v__DOT__cpu__DOT__pc,
			  top->v__DOT__mb,
			  top->v__DOT__cpu__DOT__l,
			  top->v__DOT__cpu__DOT__ac,
			  top->v__DOT__cpu__DOT__interrupt_enable,
			  top->v__DOT__cpu__DOT__IF,
			  top->v__DOT__cpu__DOT__DF,
			  top->v__DOT__cpu__DOT__UF,
			  top->v__DOT__cpu__DOT__SF,
			  top->v__DOT__cpu__DOT__IB,
			  top->v__DOT__cpu__DOT__UB);
	}
#endif

	if (tfp)
		tfp->dump(main_time);

        //main_time++;
        main_time += 20;
    }

    top->final();

    if (tfp)
	    tfp->close();
}
