/*
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/*
 * board/config.h - configuration options, board specific
 */

#ifndef __CONFIG_H
#define __CONFIG_H

/*
 * High Level Configuration Options
 * (easy to change)
 */

#define CONFIG_X86		1	/* This is a X86 CPU		*/
#define CONFIG_SC520		1	/* Include support for AMD SC520 */

#define CFG_SDRAM_PRECHARGE_DELAY 6     /* 6T */	
#define CFG_SDRAM_REFRESH_RATE    78    /* 7.8uS (choices are 7.8, 15.6, 31.2 or 62.5uS) */
#define CFG_SDRAM_RAS_CAS_DELAY   3     /* 3T */

/* define at most one of these */
#undef CFG_SDRAM_CAS_LATENCY_2T
#define CFG_SDRAM_CAS_LATENCY_3T

//#define CFG_SC520_HIGH_SPEED    0       /* 100 or 133MHz */
#define CFG_SC520_HIGH_SPEED    1       /* 100 or 133MHz */
#define CFG_RESET_GENERIC       1       /* use tripple-fault to reset cpu */
#undef  CFG_RESET_SC520                 /* use SC520 MMCR's to reset cpu */
#undef  CFG_TIMER_SC520                 /* use SC520 swtimers */
#define CFG_TIMER_GENERIC       1       /* use the i8254 PIT timers */
#undef  CFG_TIMER_TSC                   /* use the Pentium TSC timers */

#define CFG_STACK_SIZE          0x8000  /* Size of bootloader stack */

//#define CONFIG_SHOW_BOOT_PROGRESS 1
#define CONFIG_LAST_STAGE_INIT    1

/*
 * Size of malloc() pool
 */
#define CONFIG_MALLOC_SIZE	(CFG_ENV_SIZE + 128*1024)


#define CONFIG_BAUDRATE		9600

#define CONFIG_COMMANDS         (CONFIG_CMD_DFL | \
				 CFG_CMD_PCI | CFG_CMD_IDE | \
				 CFG_CMD_NET | CFG_CMD_DHCP | \
				 CFG_CMD_DOC )

/* this must be included AFTER the definition of CONFIG_COMMANDS (if any) */
#include <cmd_confdefs.h>

#define CONFIG_BOOTDELAY	15

//#define CONFIG_BOOTARGS    	"root=/dev/mtdblock0 console=ttyS0,9600"
//#define CONFIG_BOOTARGS    	"root=/dev/nfs ip=any console=ttyS0,9600"
//#define CONFIG_BOOTCOMMAND	"bootm 38000000"

#define CONFIG_BOOTARGS    	"root=/dev/hde2 ro console=ttyS0,9600"
#define CONFIG_BOOTCOMMAND	"diskboot 0x100000 2:1; bootm 0x100000"

#if (CONFIG_COMMANDS & CFG_CMD_KGDB)
#define CONFIG_KGDB_BAUDRATE	115200		/* speed to run kgdb serial port */
#define CONFIG_KGDB_SER_INDEX	2		/* which serial port to use */
#endif


/*
 * Miscellaneous configurable options
 */
#define	CFG_LONGHELP				/* undef to save memory		*/
#define	CFG_PROMPT		"boot > "	/* Monitor Command Prompt	*/
#define	CFG_CBSIZE		256		/* Console I/O Buffer Size	*/
#define	CFG_PBSIZE (CFG_CBSIZE+sizeof(CFG_PROMPT)+16) /* Print Buffer Size */
#define	CFG_MAXARGS		16		/* max number of command args	*/
#define CFG_BARGSIZE		CFG_CBSIZE	/* Boot Argument Buffer Size	*/

#define CFG_MEMTEST_START	0x00100000	/* memtest works on	*/
#define CFG_MEMTEST_END		0x01000000	/* 1 ... 16 MB in DRAM	*/

#undef  CFG_CLKS_IN_HZ		/* everything, incl board info, in Hz */

#define	CFG_LOAD_ADDR		0x100000	/* default load address	*/

#define	CFG_HZ			1024		/* incrementer freq: 1kHz */

						/* valid baudrates */
#define CFG_BAUDRATE_TABLE	{ 9600, 19200, 38400, 57600, 115200 }


/*-----------------------------------------------------------------------
 * Physical Memory Map
 */
#define CONFIG_NR_DRAM_BANKS	4	   /* we have 4 banks of DRAM */

/*-----------------------------------------------------------------------
 * FLASH and environment organization
 */

#define CFG_MAX_FLASH_BANKS	1	/* max number of memory banks	*/
#define CFG_MAX_FLASH_SECT	64	/* max number of sectors on one chip */

/* timeout values are in ticks */
#define CFG_FLASH_ERASE_TOUT	(2*CFG_HZ) /* Timeout for Flash Erase */
#define CFG_FLASH_WRITE_TOUT	(2*CFG_HZ) /* Timeout for Flash Write */

/* allow to overwrite serial and ethaddr */
#define CONFIG_ENV_OVERWRITE


/* Environment in FLASH */
#define CFG_ENV_IS_IN_FLASH   1
#define CFG_FLASH_BASE	0x38f80000

#define CFG_ENV_OFFSET	0x00030000	/* offset of environment sector */
#define CFG_ENV_SIZE	0x00010000	/* size of environment sector */

/*-----------------------------------------------------------------------
 * Device drivers
 */
#define CONFIG_NET_MULTI        /* Multi ethernet cards support */
#define CONFIG_PCNET
#define CONFIG_PCNET_79C973
#define PCNET_HAS_PROM         1

/************************************************************
 * IDE/ATA stuff
 ************************************************************/
#define CFG_IDE_MAXBUS		3   /* max. 2 IDE busses	*/
#define CFG_IDE_MAXDEVICE	(CFG_IDE_MAXBUS*2) /* max. 2 drives per IDE bus */

#define CFG_IDE_SKIP_MISSING

#define CFG_ATA_IDE0_OFFSET	0x01F0	/* ide0 offste */
//#define CFG_ATA_IDE1_OFFSET	0x0170	/* ide1 offset */
#define CFG_ATA_IDE1_OFFSET	0x30042000 /* ide1 offset */
#define CFG_ATA_IDE2_OFFSET	0x30052000 /* ide2 offset */
#define CFG_ATA_DATA_OFFSET	0	/* data reg offset */
#define CFG_ATA_REG_OFFSET	0	/* reg offset */
//#define CFG_ATA_ALT_OFFSET	0x200	/* alternate register offset */
#define CFG_ATA_ALT_OFFSET	0	/* alternate register offset */
#define CFG_ATA_BASE_ADDR       0

#define ATA_RESET_TIME		1	/* no long ide resets needed */

#undef	CONFIG_IDE_LED			/* no led for ide supported	*/
#undef  CONFIG_IDE_RESET		/* reset for ide unsupported...	*/
#undef  CONFIG_IDE_RESET_ROUTINE	/* no special reset function */

/************************************************************
 * ATAPI support (experimental)
 ************************************************************/
#define CONFIG_ATAPI			/* enable ATAPI Support */

/************************************************************
 * DISK Partition support
 ************************************************************/
#define CONFIG_DOS_PARTITION
#define CONFIG_ISO_PARTITION /* Experimental */

/************************************************************
 * Video/Keyboard support
 ************************************************************/
//#define CONFIG_VIDEO			/* To enable video controller support */
//#define CONFIG_I8042_KBD
#define CFG_ISA_IO 0



/************************************************************
 * RTC
 ***********************************************************/
//#define CONFIG_RTC_MC146818
//#undef CONFIG_WATCHDOG			/* watchdog disabled		*/
#define CONFIG_WATCHDOG			/* watchdog disabled		*/

/*
 * PCI stuff
 */
#define CONFIG_PCI                                /* include pci support */
#define CONFIG_PCI_PNP                            /* pci plug-and-play */
#define CONFIG_PCI_SCAN_SHOW

#define	CFG_FIRST_PCI_IRQ   10
#define	CFG_SECOND_PCI_IRQ  9 
#define CFG_THIRD_PCI_IRQ   11 
#define	CFG_FORTH_PCI_IRQ   15

/************************************************************
 * DOC - Disk On Chip
 ***********************************************************/
#define CFG_MAX_DOC_DEVICE	2
#define CFG_DOC_SHORT_TIMEOUT

#define CFG_DOC_BASE1	0x30010000
#define CFG_DOC_BASE2	0x30020000

#endif	/* __CONFIG_H */
