/*
 * display.c
 */

#include <stdio.h>
#include <time.h>
#include <sys/time.h>

/*
 * 16x30 display
 */

int screen_num;
char old_d1[16][30];
char d1[16][30];

char w[16][30];
char m[30];

extern int debug;
extern int testing;

/* put a string at a defined location */
int
stringat(int r, int c, char *str)
{
  int i, l;

  l = strlen(str);
  for (i = 0; i < l; i++)
    d1[r-1][c-1+i] = str[i];

  return 0;
}

/* find differences in two displays */
int
diff_display(char d1[16][30], char d2[16][30])
{
  int i, j, n;
  int s, e, diffs;
  char d[16][30];

  memset((char *)d, 0, sizeof(d));

  /* find differences */
  diffs = 0;
  for (i = 0; i < 16; i++) {
    for (j = 0; j < 30; j++) {
      d[i][j] = 0;
      if (d1[i][j] != d2[i][j]) {
	d[i][j] = 1;
	d1[i][j] = d2[i][j];
	diffs++;
      }
    }
  }

  /* optimize */
  for (i = 0; i < 16; i++) {
    for (j = 0+1; j < 30-1; j++) 
      if (d[i][j] == 0 && d[i][j-1] && d[i][j+1]) {
	d[i][j] = 1;
      }
  }

  /* send only diffs */
  for (i = 0; i < 16; i++) {
    for (j = 0; j < 30; j++) {
      if (d[i][j]) {
	s = j;
	e = j;
	for (; j < 30; j++) {
	  if (d[i][j] && j < 30-1)
	    e = j;
	  else {
	    if (debug) {
	      printf("#%d: %d..%d ", i, s, e);
	    }
	    if (!testing) {
	      send_pos(i, s, &d1[i][s], e-s+1);
	    }
	    break;
	  }
	}
      }
    }
  }
  if (diffs && debug) printf("\n");

  return 0;
}

int
dump_display(void)
{
  int i,j;

  printf("+------------------------------+\n");
  for (i = 0; i < 16; i++) {
    printf("|");
    for (j = 0; j < 30; j++) {
      printf("%c", d1[i][j]);
    }
    printf("|\n");
  }
  printf("+------------------------------+\n");

  return 0;
}

/*
  time, date
  email status
  alarm status
  weather
*/

char *time_string()
{
  static char b[32];
  time_t t;
  struct tm *tm;

  t = time(NULL);
  tm = localtime(&t);
  strftime(b, sizeof(b), "%r       %D", tm);
  return b;
}

int
get_mail()
{
  FILE *p;
  int msgs;

  p = popen("egrep '^Subject:' /var/mail/brad | wc -l", "r");
  if (p) {
    fscanf(p, "%d", &msgs);
    pclose(p);
  }

  sprintf(m, "Mail messages: %d", msgs);
  return 0;
}

char *mail_string()
{
  return m;
}

int
update_mail(void)
{
  time_t t;
  struct tm *tm;
  static int last_hour;

  if (debug) printf("update_mail()\n");

  t = time(NULL);
  tm = localtime(&t);
  if (tm->tm_hour != last_hour) {
    get_mail();
    last_hour = tm->tm_hour;
  }
}


int
get_weather(void)
{
  FILE *pi;
  int i;

  if (debug) printf("get_weather()\n");

  /* get weather via script */
  pi = popen("./weather.sh", "r");
  if (pi) {
    char l[256];

    i = 0;
    while (fgets(l, sizeof(l), pi)) {
      int ll;
      l[30] = 0;
      ll = strlen(l);
      if (l[ll-1] == '\n') l[ll-1] = 0;
      strcpy(w[i++], l);
      w[i][0] = 0;
      if (i > 15)
	break;
    }
    pclose(pi);
  }
}

int
update_weather(void)
{
  time_t t;
  struct tm *tm;
  static int last_hour;

  if (debug) printf("update_weather()\n");

  t = time(NULL);
  tm = localtime(&t);
  if (tm->tm_hour != last_hour) {
    if (last_hour == 0 ||
	last_hour == 6 ||
	last_hour == 12 ||
	last_hour == 18 ||
	last_hour == 24)
      {
	get_weather();
      }

    last_hour = tm->tm_hour;
  }
}

int
screen1(int all)
{
  char *p;
  FILE *pi;
  int i, r;

  if (debug) printf("screen1(all=%d)\n", all);
//  if (all == 0) debug = 1;

  p = time_string();
  stringat(1,1, p);

  /* partial display update - just time */
  if (!all)
	  return 0;

  p = mail_string();
  stringat(3,1, p);

  r = 5;

  /* alarm status */
  pi = popen("/usr/local/alarm/alarms 2>&1 | grep ALARM", "r");
  if (pi) {
    char l[256];

    while (fgets(l, sizeof(l), pi)) {
      int ll;
      l[30] = 0;
      ll = strlen(l);
      if (l[ll-1] == '\n') l[ll-1] = 0;
      stringat(r++, 1, l);
      if (r > 15)
	break;
    }
    pclose(pi);
  }

  /* weather */
  for (i = 0; i < 16; i++) {
    stringat(r++, 1, w[i]);
    if (r > 15)
      break;
  }
  
  return 0;
}

int
screen2(int all)
{
  char *p;

  p = time_string();
  stringat(1,1, p);

  /* partial display update - just time */
  if (!all)
	  return;

  return 0;
}

/* called periodically to update display */
int
update_display(int all)
{
  if (debug) printf("update_display(all=%d)\n", all);

  switch (screen_num) {
  case 1:
    screen1(all);
    break;
  case 2:
    screen2(all);
    break;
  }

  diff_display(old_d1, d1);
  if (testing)
    dump_display();
  return 0;
}

/* initialize display state */
int
setup_display()
{
  int i,j;

  memset((char *)d1, ' ', sizeof(d1));
  memset((char *)old_d1, ' ', sizeof(d1));

  screen_num = 1;

  return 0;
}
