#!/bin/sh
#
# get weather text
#
rm -f BOSRDFBOX.html
wget http://www.erh.noaa.gov/box/fcsts/BOSRDFBOX.html >/dev/null 2>&1 
#
# strip out all but interesting part
# if past noon, show tomorrow's weather
#
export hour=`date +%H`
gawk -- 'function skipit(line) { \
	if (length(line) == 0 || \
	    match(line, "(^Pop)|(^MN)|([Qq]pf)|(^Dewpt)|(dir)") || \
	    match(line, "[qQ]pf")) return 1; return 0; } \
	/Boston/ { \
	    while (1) { getline; if (index($0, "\\")) break; } \
	    s = index($0, "\\"); if (s == 0) s = 27; \
	    hour = ENVIRON["hour"]; if (hour < 12) s = 14; \
	    print substr($0, s+1, 18); \
	    for (i = 0; i < 16; i++) { \
		getline; \
		if (skipit($0)) continue; \
		print substr($0, 1, 10) substr($0, s, 18); \
    } } ' BOSRDFBOX.html
exit 0
