/*
 * list.c
 *
 * simple doubly linked list functions
 *
 * Brad Parker <brad@@heeltoe.com>
 */

#include <stdio.h>
#include <assert.h>
#include "list.h"

/* add to end of double linked list */
void
list_add(struct list_head *head, struct list_element *e)
{
    if (head->first == 0) {
        head->first = head->last = e;
        e->prev = (struct list_element *)0;
        e->next = (struct list_element *)0;
    } else {
        e->prev = head->last;
        e->next = (struct list_element *)0;
        head->last->next = e;
        head->last = e;
    }
}

void
list_insert_before(struct list_element *before, struct list_element *new)
{
#if 0
    new->prev = before;
    new->next = before->next;

    if (before->next) {
        before->next->prev = new;
        before->next = new;
    }
#else
    new->prev = before->prev;
    new->next = before;

    if (before->prev) {
        before->prev->next = new;
        before->prev = new;
    }
#endif
}

/* remove element from double linked list */
void
list_remove(struct list_head *head, struct list_element *e)
{
    if (e->prev)
        e->prev->next = e->next;
    else {
        /* must be head */
        assert(head->first == e);
        head->first = e->next;
    }
    if (e->next)
        e->next->prev = e->prev;
    else {
        /* must be tail */
        assert(head->last == e);
        head->last = e->prev;
    }
}

/* return first element of list */
struct list_element *
list_head(struct list_head *head)
{
    return head->first;
}

struct list_element *
list_next(struct list_element *element)
{
    return element->next;
}

/* boolean: list empty? */
int
list_empty(struct list_head *head)
{
    return head->first == NULL ? 1 : 0;
}


/*
 * Local Variables:
 * indent-tabs-mode:nil
 * c-basic-offset:4
 * End:
*/
