/*
 * telnet.h
 *
 * Brad Parker <brad@heeltoe.com>
 * $Id$
 */

#define MAX_LINE 256
#define MAX_ARGV 32

#define TELNET_GREETING "Server "
#define TELNET_PROMPT "telnet> "
#define LOGIN_PROMPT "login: "
#define PASSW_PROMPT "password: "
#define PASSW_BAD "bad username or password."

#define TELNET_WILL	251
#define TELNET_WONT	252
#define TELNET_DO	253
#define TELNET_DONT	254
#define TELNET_IAC	255

#define TELOPT_BINARY	0
#define TELOPT_ECHO	1
#define	TELOPT_SGA	3
#define	TELOPT_LINEMODE	34

struct telnet_s {
    struct list_element link;
    int socket_fd;
    int session_id;
    int source_ip;
    int source_port;

    int line_len;
    char line[MAX_LINE];
    char line2[MAX_LINE];

    int argc;
    char *argv[MAX_ARGV];

//    int (*callback)(struct telnet_s *, struct module *, int status);
//    void *callback_context;

    /* state */
    int pending;
    int has_prompt;
    int wants_to_quit;

    int cr_mode;		/* cr+lf mode */
    int cr_state;

    int iac_mode;		/* parsing IAC mode */
    char iac_flags[8];
    u_char iac_cmd;
    u_char iac_arg;
    char iac_will[256];		/* remember what we sent */
    char iac_dont[256];
    char iac_wont[256];

    int echo_mode;
    int echo_mode_save;

    int needs_negotiation;
    int needs_login;
    int login_state;
    int login_tries;
    char user[MAX_LINE];

    /* configurable */
    value_t cfg_negotiation;
    value_t cfg_login;

    value_t echo_delay;
    value_t command_delay;
    value_t line_delay;
};

char *sockaddr_in_to_text(struct sockaddr_in *in, char *text);

int telnet_stream_reader(int fd, int context);
void telnet_set_pending(struct telnet_s *telnet);
void telnet_reset_pending(struct telnet_s *telnet);


/*
 * Local Variables:
 * indent-tabs-mode:nil
 * c-basic-offset:4
 * End:
*/
