/*
 * util.c
 *
 * $Id$
 */

#include <stdio.h>

#include <sys/types.h>
#include <netinet/in.h>

#include "list.h"
#include "server.h"
#include "log.h"

char tohex(char b)
{
    b = b & 0xf;
    if (b < 10) return '0' + b;
    return 'a' + (b - 10);
}

void
dumpmem(int dbg_level, char *ptr, int len)
{
    char line[80], chars[80], *p, b, *c, *end;
    int i, j;

    end = ptr + len;
    while (ptr < end) {

	p = line;
	c = chars;

	*p++ = ' ';
	for (j = 0; j < 16; j++) {
		if (ptr < end) {
			b = *ptr++;
			*p++ = tohex(b >> 4);
			*p++ = tohex(b);
			*p++ = ' ';
			*c++ = ' ' <= b && b <= '~' ? b : '.';
		} else {
			*p++ = 'x';
			*p++ = 'x';
			*p++ = ' ';
			*c++ = 'x';
		}
	}
	*p = 0;
	*c = 0;
        debugf(dbg_level, "%08x %s %s\n", ptr, line, chars);
    }
}
