/* isr.s */

	.text
	.globl	default_isr, isr 
		
	/*
	 * exception dispatch table
	 *
	 * second entry is placed in IDT entry
	 * first entry is called after registers are saved
	 *
	 */
isr:	.quad	divide_error,		isr0x00
	.quad	debug_exception, 	isr0x01
	.quad	breakpoint,		isr0x02
	.quad	nmi,			isr0x03
	.quad	overflow,		isr0x04
	.quad	bounds_check,		isr0x05
	.quad	invalid_opcode,		isr0x06
	.quad	cop_not_avalid, 	isr0x07
	.quad	double_fault,		isr0x08
	.quad	overrun,		isr0x09
	.quad	invalid_tss,		isr0x0a
	.quad	seg_not_present, 	isr0x0b
	.quad	stack_exception, 	isr0x0c
	.quad	general_protection, 	isr0x0d
	.quad	page_fault,		isr0x0e
	.quad	reserved,		isr0x0f
	.quad	coprocessor_error, 	isr0x10
	.quad	reserved,		isr0x11
	.quad	reserved,		isr0x12
	.quad	reserved,		isr0x13
	.quad	reserved,		isr0x14
	.quad	reserved,		isr0x15
	.quad	reserved,		isr0x16
	.quad	reserved,		isr0x17
	.quad	reserved,		isr0x18
	.quad	reserved,		isr0x19
	.quad	reserved,		isr0x1a
	.quad	reserved,		isr0x1b
	.quad	reserved,		isr0x1c
	.quad	reserved,		isr0x1d
	.quad	reserved,		isr0x1e
	.quad	reserved,		isr0x1f
	.quad	do_timer,		isr0x20 /* irq0 */
	.quad	do_keyboard,		isr0x21 /* irq1 */
.if 0
	.quad	reserved,		isr0x22 /* irq2 */
	.quad	do_com24,		isr0x23 /* irq3 */
	.quad	do_com13,		isr0x24 /* irq4 */
	.quad	do_lpt2,		isr0x25 /* irq5 */
	.quad	do_floppy,		isr0x26 /* irq6 */
	.quad	do_lpt1,		isr0x27 /* irq7 */
	.quad	do_rtc,			isr0x28 /* irq8 */
	.quad	do_swint,		isr0x29 /* irq9 */
	.quad	reserved,		isr0x2a /* irq10 */
	.quad	reserved,		isr0x2b /* irq11 */
	.quad	reserved,		isr0x2c /* irq12 */
	.quad	do_math,		isr0x2d /* irq13 */
	.quad	do_ide0,		isr0x2e /* irq14 */
	.quad	do_ide1,		isr0x2f /* irq15 */
.endif
	
/*
  Format of stack when exception code is called:
	
	+-----------+
	|  old  ss  |
	+-----------+
	|  old esp  |
	+-----------+
	|  eflags   |
	+-----------+
	|    cs     |
	+-----------+
	|   eip     | 72
	+-----------+
	|  0/err    | 64
	+-----------+
	|  isr_nr   | 56 tmp = esp
	+-----------+
	|   eax     | 48
	+-----------+
	|   ebx     | 40
	+-----------+
	|   ecx     | 32
	+-----------+
	|   edx     | 24
	+-----------+
	|   ebp     | 16
	+-----------+
	|   esi     | 8
	+-----------+
	|   edi     | 0
	+-----------+
*/
isr_comm:
	pushq	%rax
	pushq	%rbx
	pushq	%rcx
	pushq	%rdx
	pushq	%rbp
	pushq	%rsi
	pushq	%rdi
	
	movq	56(%esp),%rcx
	add	%rcx, %rcx
	
	call	*isr(, %rcx, 8)
	
	popq	%rdi
	popq	%rsi
	popq	%rbp
	popq	%rdx
	popq	%rcx
	popq	%rbx
	popq 	%rax

	addq	$16,%rsp	# for isr_nr and err_code
	iretq

	.macro	isrnoerror nr
isr\nr:
	pushq	$0
	pushq	$\nr 
	jmp	isr_comm
	.endm

	.macro	isrerror nr
isr\nr:
	pushq	$\nr
	jmp	isr_comm
	.endm

	/* exception stubs */
	isrNoError	0x00
	isrNoError	0x01
	isrNoError	0x02
	isrNoError	0x03
	isrNoError	0x04
	isrNoError	0x05
	isrNoError	0x06
	isrNoError	0x07
	isrError	0x08
	isrNoError	0x09
	isrError	0x0a
	isrError	0x0b
	isrError	0x0c
	isrError	0x0d
	isrError	0x0e
	isrNoError	0x0f
	isrError	0x10
	isrNoError	0x11
	isrNoError	0x12
	isrNoError	0x13
	isrNoError	0x14
	isrNoError	0x15
	isrNoError	0x16
	isrNoError	0x17
	isrNoError	0x18
	isrNoError	0x19
	isrNoError	0x1a
	isrNoError	0x1b
	isrNoError	0x1c
	isrNoError	0x1d
	isrNoError	0x1e
	isrNoError	0x1f
	isrNoError	0x20
	isrNoError	0x21
	
default_isr:
	# wiggle screen 
	incb	0xb8000
	movb	$2, 0xb8001

	movb	$0x20, %al
	outb	%al, $0x20
	outb	%al, $0xa0
	iretq

