#
# pxe boot x86 boot sector - loaded at 0x7c00
#
#
	.text
	.globl	start
	.code16
start:
	cli
	xorw	%ax,%ax
	movw	%ax,%ds		# ds = 0x0000
	movw	%ax,%ss		# stack segment = 0x0000
	movw	%ax,%es
	movw	$0x7c00,%sp	# arbitrary value 
				# used before pmode
	
	jmp clear_cs
clear_cs:
	cli

	# enable A20 via port 92h
	inb	$0x92,%al
	orb	$0x02,%al
	outb	%al,$0x92

# page table, for ia-32e mode using 2mb entries
# cr3 -> PML4 (0xa000)
# PL4 has 512 entries of 8 bytes each. Each entry points to a PDP entry.
# PDP has 512 entries of 8 bytes each. Each entry points to a PD entry.
# each PD has 512 entries of 8 bytes each. Each entry maps 2mb.
#
# linear mapping for 16gb = 0x4_0000_0000
#
# PML4: (page map level 4, index = address bits 47:39, 0000ff80 00000000)
# 70000: 0000 0000 0007 100f	entry 0		0..511GB
# 70008: 0000 0000 0000 0000	entry 1		(empty)	
#        ...
# 70ff8: 0000 0000 0000 0000	entry 511
#
# PDP: (page-directory-pointer, index = address bits 38:30, 0000007f c0000000)
# 71000: 0000 0000 0008 000f	entry 0		1gb page
#      : 0000 0000 0008 100f	entry 1
#      : 0000 0000 0008 200f	entry 2
#      : 0000 0000 0008 300f	entry 3
#      : 0000 0000 0008 400f	entry 4
#      : 0000 0000 0008 500f	entry 5
#      : 0000 0000 0008 600f	entry 6
#      : 0000 0000 0008 700f	entry 7
#      : 0000 0000 0008 800f	entry 8
#      : 0000 0000 0008 900f	entry 9
#      : 0000 0000 0008 a00f	entry 10
#      : 0000 0000 0008 b00f	entry 11
#      : 0000 0000 0008 c00f	entry 12
#      : 0000 0000 0008 d00f	entry 13
#      : 0000 0000 0008 e00f	entry 14
#      : 0000 0000 0008 f00f	entry 15
#      : 0000 0000 0000 0000	entry 16  (empty)
#        ...
# 71ff8: 0000 0000 0000 0000	entry 511 (empty)
#
# PD: (page-directory, index = )
# 80000: 0000 0000 0000 018f	entry 0
#      : 0000 0000 0020 018f	entry 1
#      : 0000 0000 0040 018f	entry 2
#        ...
# 80ff8: 0000 0000 3fe0 018f	entry 511
#	
# 81000: 0000 0000 4000 018f	entry 0
#      : 0000 0000 4020 018f	entry 1
#      : 0000 0000 4040 018f	entry 2
#        ...
# 81ff8: 0000 0000 7fe0 018f	entry 511
#
# 82000: 0000 0000 8000 018f	entry 0
#        ...
#
# 83000: 0000 0000 c000 018f	entry 0
#        ...
#
# 84000: 0000 0001 0000 018f	entry 0
#        ...
#
	
	movw	$0x7000,%ax
	movw	%ax,%es
	cld

	#
	# create PML4 entries
	#
	movw	$0x0000,%di
	movw	$0x100f,%ax
	stosw
	movw	$0x0007,%ax
	stosw
	xorw	%ax,%ax
	stosw
	xorw	%ax,%ax
	stosw
	
	# fill out table
	movw	$(512-1)*4,%cx
	rep stosw

	#
	# create 16 PDP entries, 1gb each
	#
	movw	$0x000f,%bx
	movw	$0x0008,%dx
	movw	$16,%cx
	
make_pdpe:
	movw	%bx,%ax
	stosw
	movw	%dx,%ax
	stosw
	xor	%ax,%ax
	stosw
	stosw
	
	addw	$0x1000,%bx
	adcw	$0x0,%dx
	
	loop	make_pdpe

	# fill out table
	xorw	 %ax,%ax
	mov	$(512-16)*4,%cx
	rep stosw

	#
	# createe 16 PD tables, 4k each
	#
	movw	$0x8000,%ax
	movw	%ax,%es
	movw	$0x0000,%di
	
	movw	$16,%cx
	movw	$0x0000,%bx
	movw	$0x0000,%dx

make_pd:
	push	%cx
	movw	$512,%cx
make_pde:	
	movw	$0x018f,%ax
	stosw
	movw	%bx,%ax
	stosw
	movw	%dx,%ax
	stosw
	xorw	%ax,%ax
	stosw

	addw	$0x0020,%bx
	adcw	$0x0,%dx
	
	loop	make_pde
	pop	%cx
	
	loop	make_pd

	## Enter long mode
	movl	$0xa0,%eax		# Set PAE and PGE
	movl	%eax,%cr4

	movl	$0x00070000,%edx	# Point CR3 at PML4
	movl	%edx,%cr3

	movl	$0xc0000080,%ecx	# Specify EFER MSR
	rdmsr				# Enable Long Mode
	orl	$0x00000100,%eax
	wrmsr

	movl	%cr0, %ebx		# Activate long mode
	orl	$0x80000001, %ebx	# by enabling paging and protection simultaneously
	movl	%ebx, %cr0		# skipping protected mode entirely

	lgdt	gdt_48

	ljmp	$0x08, $(0x8000)

	.align 4
gdt:   
	.quad	0x0000000000000000 # null descriptor
	.quad	0x0020980000000000 # 0x08 code64
	.quad	0x0000900000000000 # 0x10 data64

gdt_48:
	.word	.-gdt-1
	.long	gdt
	.long	0

	.org	0x400, 0x90	

