/* init.c */


void
s(char *p)
{
	volatile unsigned short *s;
	char ch;

	s = (unsigned short *)0xb8000;
	while ((ch = *p++)) {
		*s = (*s & 0xff00) | (ch & 0xff);
		s++;
	}

	s = (unsigned short *)0xb8000;
	s += 80;
	*s = (*s & 0xff00) | 'X';
}

char hex(int n)
{
	return "0123456789ABCDEF"[n&0xf];
}

void sn(int line, unsigned int v)
{
	volatile unsigned short *s;
	char ch;
	int i;

	s = (unsigned short *)0xb8000;
	s += 80 * line;

	for (i = 0; i < 8; i++) {
		ch = hex(v >> (28-i*4));
		*s = (*s & 0xff00) | (ch & 0xff);
                s++;
	}
}

void cpuid(void)
{
	unsigned int ax, bx, cx, dx, func;

	func = 0x80000001;
	__asm__ __volatile__ ("cpuid":
			      "=a" (ax), "=b" (bx), "=c" (cx), "=d" (dx) : "a" (func));
	sn(2, dx);
	sn(3, dx & (1<<26));
}

typedef unsigned long long uint64_t;
typedef unsigned long long u64;
typedef unsigned long long __u64;
typedef unsigned int __u32;

typedef union {
    uint64_t raw;
    struct {
        uint64_t type : 8;
        uint64_t reserved1 : 4;
        /* TBD: the end of base really depends on MAXPHYADDR, but since */
        /* the MTRRs are set for SINIT and it must be <4GB, can use 24b */
        uint64_t base : 24;
        uint64_t reserved2 : 28;
    };
} mtrr_physbase_t;

typedef union {
    uint64_t raw;
    struct {
        uint64_t reserved1 : 11;
        uint64_t v : 1; /* valid */
        /* TBD: the end of mask really depends on MAXPHYADDR, but since */
        /* the MTRRs are set for SINIT and it must be <4GB, can use 24b */
        uint64_t mask : 24;
        uint64_t reserved2 : 28;
    };
} mtrr_physmask_t; 

typedef union {
    uint64_t raw;
    struct {
        uint64_t type : 8;
        uint64_t reserved1 : 2;
        uint64_t fe : 1; /* fixed MTRR enable */
        uint64_t e : 1; /* (all) MTRR enable */
        uint64_t reserved2 : 52;
    };
} mtrr_def_type_t;

enum var_mtrr_t {
    MTRR_PHYS_BASE0_MSR = 0x200,
    MTRR_PHYS_MASK0_MSR = 0x201,
    MTRR_PHYS_BASE1_MSR = 0x202,
    MTRR_PHYS_MASK1_MSR = 0x203,
    MTRR_PHYS_BASE2_MSR = 0x204,
    MTRR_PHYS_MASK2_MSR = 0x205,
    MTRR_PHYS_BASE3_MSR = 0x206,
    MTRR_PHYS_MASK3_MSR = 0x207,
    MTRR_PHYS_BASE4_MSR = 0x208,
    MTRR_PHYS_MASK4_MSR = 0x209,
    MTRR_PHYS_BASE5_MSR = 0x20A,
    MTRR_PHYS_MASK5_MSR = 0x20B,
    MTRR_PHYS_BASE6_MSR = 0x20C,
    MTRR_PHYS_MASK6_MSR = 0x20D,
    MTRR_PHYS_BASE7_MSR = 0x20E,
    MTRR_PHYS_MASK7_MSR = 0x20F
};

typedef union {
    uint64_t raw;
    struct {
        uint64_t vcnt : 8; /* num variable MTRR pairs */
        uint64_t fix : 1; /* fixed range MTRRs are supported */
        uint64_t reserved1 : 1;
        uint64_t wc : 1; /* write-combining mem type supported */
        uint64_t reserved2 : 53;
    };
} mtrr_cap_t;
 

#define rdmsrl(msr,val) do { unsigned long a__,b__; \
       __asm__ __volatile__("rdmsr" \
			    : "=a" (a__), "=d" (b__) \
			    : "c" (msr)); \
       val = a__ | ((u64)b__<<32); \
} while(0);

#define wrmsr(msr,val1,val2) \
     __asm__ __volatile__("wrmsr" \
			  : /* no outputs */ \
			  : "c" (msr), "a" (val1), "d" (val2))

static inline void wrmsrl(unsigned int msr, __u64 val)
{
        __u32 lo, hi;
        lo = (__u32)val;
        hi = (__u32)(val >> 32);
        wrmsr(msr, lo, hi);
}

#define MSR_MTRRcap                     0x0fe
#define MSR_IA32_MTRRCAP                MSR_MTRRcap
#define MSR_IA32_MTRR_DEF_TYPE          0x2ff

#define MTRR_TYPE_UNCACHABLE 0
#define MTRR_TYPE_WRCOMB     1
#define MTRR_TYPE_WRTHROUGH  4
#define MTRR_TYPE_WRPROT     5
#define MTRR_TYPE_WRBACK     6
#define MTRR_NUM_TYPES       7

void reset_all_mtrrs(void)
{
    mtrr_def_type_t mtrr_def_type;
    mtrr_cap_t mtrr_cap;
    mtrr_physmask_t mtrr_physmask;
    mtrr_physbase_t mtrr_physbase;
    int ndx;

    /* initially disable all variable MTRRs */
    rdmsrl(MSR_IA32_MTRRCAP, mtrr_cap.raw);
    for (ndx = 0; ndx < mtrr_cap.vcnt; ndx++) {
        rdmsrl(MTRR_PHYS_MASK0_MSR + ndx*2, mtrr_physmask.raw);
        mtrr_physmask.v = 0;
        wrmsrl(MTRR_PHYS_MASK0_MSR + ndx*2, mtrr_physmask.raw);
    }

#if 0
    rdmsrl(MTRR_PHYS_MASK0_MSR, mtrr_physmask.raw);
    mtrr_physmask.v = 1;
    mtrr_physmask.mask = 0xffffff;
    wrmsrl(MTRR_PHYS_MASK0_MSR, mtrr_physmask.raw);

    rdmsrl(MTRR_PHYS_BASE0_MSR, mtrr_physbase.raw);
    mtrr_physbase.type = MTRR_TYPE_WRBACK;
    mtrr_physbase.base = 0x0;
    wrmsrl(MTRR_PHYS_BASE0_MSR, mtrr_physbase.raw);
#endif

//E = 1 << 11
//FE = 1 << 10
//    disable fe, enable e

    rdmsrl(MSR_IA32_MTRR_DEF_TYPE, mtrr_def_type.raw);
    mtrr_def_type.e = 1;
    mtrr_def_type.fe = 0;
    mtrr_def_type.type = MTRR_TYPE_WRBACK;
    wrmsrl(MSR_IA32_MTRR_DEF_TYPE, mtrr_def_type.raw);
} 

extern volatile unsigned int timer_ticks;
extern volatile unsigned int timer_100ms;

void
perf(void)
{
    unsigned int t0, t1;
    unsigned int loops;

    loops = 0;
    t0 = timer_ticks;
    t1 = t0 + 10;

    while (1) {
        if (timer_ticks == t1)
            break;
        loops++;
    }

    sn(7, loops);
}

void 
run(void)
{
	unsigned long long *p;
	int i;

	p = (unsigned long long *)0xb8000;
	for (i = 0; i < 480; i++) {
		*p++ = 0x1f201f201f201f20ULL;
	}

	s("I'm in 64 bit mode!");

	cpuid();

        reset_all_mtrrs();

        perf();

	while (1) {
            sn(4, timer_ticks);
            sn(5, timer_100ms);
        }
}

/*
 * Local Variables:
 * indent-tabs-mode:nil
 * c-basic-offset:4
 * End:
*/
