/* timer.c */

#include "inout.h"

volatile unsigned int timer_ticks;
volatile unsigned int timer_100ms;

void
do_keyboard(void)
{
    int com;
    unsigned char scan_code;

    /* */
    scan_code = inb(0x60);

    /* key stroke has been handled */
    com = inb(0x61);
    outb(com | 0x80, 0x61);
    outb(com & 0x7f, 0x61);

    outb(0x20, 0x20);
}

void
do_timer(void)
{
    timer_ticks++;
    timer_100ms++;
    outb(0x20, 0x20);
}

void
timer_install(int hz)
{
    unsigned int divisor;

    timer_ticks = 0;
    divisor = 1193180/hz;

    outb(0x36, 0x43);
    outb(divisor&0xff, 0x40);
    outb(divisor>>8, 0x40);

    /* unmask interrupt */
    outb(inb(0x21)&0xfe, 0x21);
}

/*
 * Local Variables:
 * indent-tabs-mode:nil
 * c-basic-offset:4
 * End:
*/
